/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.CiSpec$;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.deployit.ascode.Version$;
import com.xebialabs.deployit.ascode.service.DefinitionGeneratorService$;
import com.xebialabs.deployit.ascode.service.validation.PermissionValidator$;
import com.xebialabs.deployit.core.IdExtensions$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.None$;
import scala.Option;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001=<Qa\u0003\u0007\t\u0002]1Q!\u0007\u0007\t\u0002iAQ!I\u0001\u0005\u0002\tBqaI\u0001C\u0002\u0013\u0005A\u0005\u0003\u0004)\u0003\u0001\u0006I!\n\u0004\u000531\u0001\u0011\u0006\u0003\u0005+\u000b\t\u0005\t\u0015!\u0003,\u0011!\u0001TA!A!\u0002\u0013\t\u0004\"B\u0011\u0006\t\u00039\u0004\"\u0002&\u0006\t\u0013Y\u0005\"\u0002/\u0006\t\u0003i\u0016A\u0007#fM&t\u0017\u000e^5p]\u001e+g.\u001a:bi>\u00148+\u001a:wS\u000e,'BA\u0007\u000f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0004\t\u0002\r\u0005\u001c8m\u001c3f\u0015\t\t\"#\u0001\u0005eKBdw._5u\u0015\t\u0019B#A\u0005yK\nL\u0017\r\\1cg*\tQ#A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0019\u00035\tAB\u0001\u000eEK\u001aLg.\u001b;j_:<UM\\3sCR|'oU3sm&\u001cWm\u0005\u0002\u00027A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\f\u0002#\u001d+e*\u0012*B)\u0016{6)S0M\u00136KE+F\u0001&!\tab%\u0003\u0002(;\t\u0019\u0011J\u001c;\u0002%\u001d+e*\u0012*B)\u0016{6)S0M\u00136KE\u000bI\n\u0003\u000bm\t!B]3q_NLGo\u001c:z!\tac&D\u0001.\u0015\tQ\u0003#\u0003\u00020[\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\t\u0003eUj\u0011a\r\u0006\u0003iA\t\u0001b]3dkJLG/_\u0005\u0003mM\u0012!\u0003U3s[&\u001c8/[8o\u000b:4wN]2feR\u0019\u0001(\u000f\u001e\u0011\u0005a)\u0001\"\u0002\u0016\t\u0001\u0004Y\u0003\"\u0002\u0019\t\u0001\u0004\t\u0004F\u0001\u0005=!\ti\u0004*D\u0001?\u0015\ty\u0004)\u0001\u0006b]:|G/\u0019;j_:T!!\u0011\"\u0002\u000f\u0019\f7\r^8ss*\u00111\tR\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u000b\u001a\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%s$!C!vi><\u0018N]3e\u0003!1\u0018\r\\5eCR,GC\u0001'P!\taR*\u0003\u0002O;\t!QK\\5u\u0011\u0015\u0001\u0016\u00021\u0001R\u0003\u0011\u0019\u0017.\u00133\u0011\u0005IKfBA*X!\t!V$D\u0001V\u0015\t1f#\u0001\u0004=e>|GOP\u0005\u00031v\ta\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001,H\u0001\tO\u0016tWM]1uKR\u0011al\u001a\t\u0003?\u0016l\u0011\u0001\u0019\u0006\u0003C\n\fQ!\\8eK2T!a\u00193\u0002\te\fW\u000e\u001c\u0006\u0003\u001fII!A\u001a1\u0003\u0015\u0011+g-\u001b8ji&|g\u000eC\u0003Q\u0015\u0001\u0007\u0011\u000b\u000b\u0002\u0006SB\u0011!.\\\u0007\u0002W*\u0011A\u000eR\u0001\u000bgR,'/Z8usB,\u0017B\u00018l\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DefinitionGeneratorService {
    private final RepositoryService repository;
    private final PermissionEnforcer permissionEnforcer;

    public static int GENERATE_CI_LIMIT() {
        return DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT();
    }

    private void validate(String ciId) {
        if (ciId.isEmpty()) {
            throw new AsCodeException("Generate path cannot be empty", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (ciId.startsWith("/")) {
            throw new AsCodeException(new StringBuilder(68).append("Cannot generate definition for path `").append(ciId).append("`. It should not start with `/`").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (!this.repository.exists(ciId)) {
            throw new AsCodeException(new StringBuilder(30).append("A CI with id `").append(ciId).append("` does not exist").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String string = ciId;
        PermissionValidator$.MODULE$.checkPermissions(PlatformPermissions.READ, (List<String>)Nil$.MODULE$.$colon$colon((Object)string));
    }

    public Definition generate(String ciId) {
        this.validate(ciId);
        SearchParameters params = new SearchParameters();
        params.setAncestor(ciId);
        params.setResultsPerPage((long)(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT() + 1));
        this.permissionEnforcer.applyLoggedInUserPermission(params, PlatformPermissions.READ);
        List cis = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repository.listEntities(params)).toList();
        if (cis.length() > DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()) {
            throw new AsCodeException(new StringBuilder(124).append("The result contains more then ").append(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()).append(" configuration items. Please narrow down the amount of CIs by specifying a more specific path.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return new Definition(Version$.MODULE$.XLD_API_VERSION(), (Option)None$.MODULE$, IdExtensions$.MODULE$.idString(ciId).getRoot(), (Spec)new CiSpec(cis, CiSpec$.MODULE$.apply$default$2(), CiSpec$.MODULE$.apply$default$3()));
    }

    @Autowired
    public DefinitionGeneratorService(RepositoryService repository, PermissionEnforcer permissionEnforcer) {
        this.repository = repository;
        this.permissionEnforcer = permissionEnforcer;
    }
}

