/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.CiSpec$;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.deployit.ascode.Version$;
import com.xebialabs.deployit.ascode.service.DefinitionGeneratorService$;
import com.xebialabs.deployit.ascode.service.validation.PermissionValidator;
import com.xebialabs.deployit.core.IdExtensions$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.None$;
import scala.Option;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001a<Q\u0001D\u0007\t\u0002a1QAG\u0007\t\u0002mAQAI\u0001\u0005\u0002\rBq\u0001J\u0001C\u0002\u0013\u0005Q\u0005\u0003\u0004*\u0003\u0001\u0006IA\n\u0004\u000555\u0001!\u0006\u0003\u0005,\u000b\t\u0005\t\u0015!\u0003-\u0011!\tTA!A!\u0002\u0013\u0011\u0004\u0002\u0003\u001d\u0006\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\t*A\u0011A \t\u000bM+A\u0011\u0002+\t\u000b\u0015,A\u0011\u00014\u00025\u0011+g-\u001b8ji&|gnR3oKJ\fGo\u001c:TKJ4\u0018nY3\u000b\u00059y\u0011aB:feZL7-\u001a\u0006\u0003!E\ta!Y:d_\u0012,'B\u0001\n\u0014\u0003!!W\r\u001d7ps&$(B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001!\tI\u0012!D\u0001\u000e\u0005i!UMZ5oSRLwN\\$f]\u0016\u0014\u0018\r^8s'\u0016\u0014h/[2f'\t\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\t\u0011cR#O\u000bJ\u000bE+R0D\u0013~c\u0015*T%U+\u00051\u0003CA\u000f(\u0013\tAcDA\u0002J]R\f!cR#O\u000bJ\u000bE+R0D\u0013~c\u0015*T%UAM\u0011Q\u0001H\u0001\u000be\u0016\u0004xn]5u_JL\bCA\u00170\u001b\u0005q#BA\u0016\u0012\u0013\t\u0001dFA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f!\u0003]3s[&\u001c8/[8o\u000b:4wN]2feB\u00111GN\u0007\u0002i)\u0011Q'E\u0001\tg\u0016\u001cWO]5us&\u0011q\u0007\u000e\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:4\u0016\r\\5eCR|'\u000f\u0005\u0002;{5\t1H\u0003\u0002=\u001b\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\u0005yZ$a\u0005)fe6L7o]5p]Z\u000bG.\u001b3bi>\u0014H\u0003\u0002!B\u0005\u000e\u0003\"!G\u0003\t\u000b-J\u0001\u0019\u0001\u0017\t\u000bEJ\u0001\u0019\u0001\u001a\t\u000baJ\u0001\u0019A\u001d)\u0005%)\u0005C\u0001$R\u001b\u00059%B\u0001%J\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0015.\u000bqAZ1di>\u0014\u0018P\u0003\u0002M\u001b\u0006)!-Z1og*\u0011ajT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001+A\u0002pe\u001eL!AU$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\u0005UC\u0006CA\u000fW\u0013\t9fD\u0001\u0003V]&$\b\"B-\u000b\u0001\u0004Q\u0016\u0001B2j\u0013\u0012\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/\u001f\u001b\u0005q&BA0\u0018\u0003\u0019a$o\\8u}%\u0011\u0011MH\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b=\u0005Aq-\u001a8fe\u0006$X\r\u0006\u0002haB\u0011\u0001N\\\u0007\u0002S*\u0011!n[\u0001\u0006[>$W\r\u001c\u0006\u0003Y6\fA!_1nY*\u0011\u0001cE\u0005\u0003_&\u0014!\u0002R3gS:LG/[8o\u0011\u0015I6\u00021\u0001[Q\t)!\u000f\u0005\u0002tm6\tAO\u0003\u0002v\u001b\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\u0005]$(aB*feZL7-\u001a")
public class DefinitionGeneratorService {
    private final RepositoryService repository;
    private final PermissionEnforcer permissionEnforcer;
    private final PermissionValidator permissionValidator;

    public static int GENERATE_CI_LIMIT() {
        return DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT();
    }

    private void validate(String ciId) {
        if (ciId.isEmpty()) {
            throw new AsCodeException("Generated path cannot be empty", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (ciId.startsWith("/")) {
            throw new AsCodeException(new StringBuilder(68).append("Cannot generate definition for path `").append(ciId).append("`. It should not start with `/`").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (!this.repository.exists(ciId)) {
            throw new AsCodeException(new StringBuilder(30).append("A CI with id `").append(ciId).append("` does not exist").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String string = ciId;
        this.permissionValidator.checkPermissions(PlatformPermissions.READ, (List<String>)Nil$.MODULE$.$colon$colon((Object)string));
    }

    public Definition generate(String ciId) {
        this.validate(ciId);
        SearchParameters params = new SearchParameters();
        params.setAncestor(ciId);
        params.setResultsPerPage((long)(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT() + 1));
        this.permissionEnforcer.applyLoggedInUserPermission(params, PlatformPermissions.READ);
        List cis = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repository.listEntities(params)).toList();
        if (cis.length() > DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()) {
            throw new AsCodeException(new StringBuilder(124).append("The result contains more then ").append(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()).append(" configuration items. Please narrow down the amount of CIs by specifying a more specific path.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return new Definition(Version$.MODULE$.XLD_API_VERSION(), (Option)None$.MODULE$, IdExtensions$.MODULE$.idString(ciId).getRoot(), (Spec)new CiSpec(cis, CiSpec$.MODULE$.apply$default$2(), CiSpec$.MODULE$.apply$default$3()));
    }

    @Autowired
    public DefinitionGeneratorService(RepositoryService repository, PermissionEnforcer permissionEnforcer, PermissionValidator permissionValidator) {
        this.repository = repository;
        this.permissionEnforcer = permissionEnforcer;
        this.permissionValidator = permissionValidator;
    }
}

