/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.PreviewResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.ascode.service.spec.util.DeploymentPreparationService;
import com.xebialabs.deployit.ascode.yaml.model.Constants$Kinds$;
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.ParallelBlock;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.SerialBlock;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011a\u0002\u0015:fm&,woU3sm&\u001cWM\u0003\u0002\u0004\t\u000591/\u001a:wS\u000e,'BA\u0003\u0007\u0003\u0019\t7oY8eK*\u0011q\u0001C\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002#\u0011,\u0007\u000f\\8z[\u0016tGoU3sm&\u001cW\r\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005m1\u0011AB3oO&tW-\u0003\u0002\u001e1\t\tB)\u001a9m_flWM\u001c;TKJ4\u0018nY3\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA\u0004Z3qY>LX.\u001a8u!J,\u0007/\u0019:bi&|gnU3sm&\u001cW\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!Q\u000f^5m\u0015\t)#!\u0001\u0003ta\u0016\u001c\u0017BA\u0014#\u0005q!U\r\u001d7ps6,g\u000e\u001e)sKB\f'/\u0019;j_:\u001cVM\u001d<jG\u0016DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDcA\u0016.]A\u0011A\u0006A\u0007\u0002\u0005!)Q\u0003\u000ba\u0001-!)q\u0004\u000ba\u0001A!)\u0001\u0007\u0001C\u0005c\u0005\u0011BO]1og\u001a|'/\\*uKB\u001cF/\u0019;f)\t\u00114\n\u0005\u00024\u0011:\u0011A'\u0012\b\u0003k\ts!AN \u000f\u0005]rdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYD\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000b!I!\u0001Q!\u0002\te\fW\u000e\u001c\u0006\u0003\u000b!I!a\u0011#\u0002\u0007\u0011$xN\u0003\u0002A\u0003&\u0011aiR\u0001\u0010!J,g/[3x%\u0016\u001c\bo\u001c8tK*\u00111\tR\u0005\u0003\u0013*\u0013q\u0002V1tWB\u0013XM^5fo&#X-\u001c\u0006\u0003\r\u001eCQ\u0001T\u0018A\u00025\u000b\u0011b\u001d;faN#\u0018\r^3\u0011\u00059\u000bV\"A(\u000b\u0005AC\u0012!C3yK\u000e,H/[8o\u0013\t\u0011vJA\u0005Ti\u0016\u00048\u000b^1uK\")A\u000b\u0001C\u0005+\u0006\u0019BO]1og\u001a|'/\u001c\"m_\u000e\\7\u000b^1uKR\u0019ak\u00183\u0011\u0007]c&G\u0004\u0002Y5:\u0011\u0011(W\u0005\u0002#%\u00111\fE\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0003MSN$(BA.\u0011\u0011\u0015\u00017\u000b1\u0001b\u0003)\u0011Gn\\2l'R\fG/\u001a\t\u0003\u001d\nL!aY(\u0003\u0015\tcwnY6Ti\u0006$X\rC\u0004f'B\u0005\t\u0019\u00014\u0002\u0015%\u001c\b+\u0019:bY2,G\u000e\u0005\u0002\u0010O&\u0011\u0001\u000e\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0007\u0001\"\u0003l\u0003I9W\r\u001e+bg.$Um]2sSB$\u0018n\u001c8\u0015\u00051$\bCA7r\u001d\tqw\u000e\u0005\u0002:!%\u0011\u0001\u000fE\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002q!!)Q/\u001ba\u0001m\u0006QA-\u001a9m_flWM\u001c;\u0011\u0005]LX\"\u0001=\u000b\u0005\rC\u0012B\u0001>y\u0005)!U\r\u001d7ps6,g\u000e\u001e\u0005\u0006y\u0002!\t!`\u0001\baJ,g/[3x)\rq\u0018Q\u0001\t\u0004\u007f\u0006\u0005Q\"A$\n\u0007\u0005\rqIA\bQe\u00164\u0018.Z<SKN\u0004xN\\:f\u0011\u001d\t9a\u001fa\u0001\u0003\u0013\t!\u0002Z3gS:LG/[8o!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b\t\u0006)Qn\u001c3fY&!\u00111CA\u0007\u0005)!UMZ5oSRLwN\u001c\u0005\n\u0003/\u0001\u0011\u0013!C\u0005\u00033\tQ\u0004\u001e:b]N4wN]7CY>\u001c7n\u0015;bi\u0016$C-\u001a4bk2$HEM\u000b\u0003\u00037Q3AZA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007f\u0001\u0001\u00022A!\u00111GA$\u001b\t\t)D\u0003\u0003\u0002*\u0005]\"\u0002BA\u001d\u0003w\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002>\u0005}\u0012!\u00022fC:\u001c(\u0002BA!\u0003\u0007\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u000b\n1a\u001c:h\u0013\u0011\tI%!\u000e\u0003\u0013\u0005+Ho\\<je\u0016$\u0007f\u0001\u0001\u0002NA!\u0011qJA+\u001b\t\t\tF\u0003\u0003\u0002T\u0005}\u0012AC:uKJ,w\u000e^=qK&!\u0011qKA)\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class PreviewService {
    private final DeploymentService deploymentService;
    private final DeploymentPreparationService deploymentPreparationService;

    private PreviewResponse.TaskPreviewItem transformStepState(StepState stepState) {
        return new PreviewResponse.TaskPreviewItem(stepState.getDescription(), (List)Nil$.MODULE$, PreviewResponse.TaskPreviewItem$.MODULE$.apply$default$3());
    }

    private List<PreviewResponse.TaskPreviewItem> transformBlockState(BlockState blockState, boolean isParallel) {
        Nil$ nil$;
        block7: {
            BlockState blockState2;
            while (true) {
                if ((blockState2 = blockState) instanceof PhaseContainer) {
                    PhaseContainer phaseContainer = (PhaseContainer)blockState2;
                    List children = (List)phaseContainer.phases().toList().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.transformBlockState((BlockState)x$1, this.transformBlockState$default$2()), List$.MODULE$.canBuildFrom());
                    nil$ = (List)Option$.MODULE$.apply((Object)phaseContainer.description()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$transformBlockState$2(x$2))).map((Function1 & Serializable & scala.Serializable)desc -> {
                        PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(desc, children, isParallel);
                        return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> children);
                    break block7;
                }
                if (blockState2 instanceof ParallelBlock) {
                    ParallelBlock parallelBlock = (ParallelBlock)blockState2;
                    String description = parallelBlock.description();
                    Seq blocks = parallelBlock.blocks();
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, (List)blocks.toList().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.transformBlockState((BlockState)x$4, true), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (blockState2 instanceof SerialBlock) {
                    SerialBlock serialBlock = (SerialBlock)blockState2;
                    String description = serialBlock.description();
                    Seq blocks = serialBlock.blocks();
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, (List)blocks.toList().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> this.transformBlockState((BlockState)x$6, this.transformBlockState$default$2()), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (blockState2 instanceof StepBlockState) {
                    StepBlockState stepBlockState = (StepBlockState)blockState2;
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(stepBlockState.getDescription(), (List)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(stepBlockState.getSteps()).toList().map((Function1 & Serializable & scala.Serializable)stepState -> this.transformStepState((StepState)stepState), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (!(blockState2 instanceof Phase)) break;
                Phase phase = (Phase)blockState2;
                isParallel = this.transformBlockState$default$2();
                blockState = phase.block();
            }
            if (blockState2 instanceof Block) {
                Block block = (Block)blockState2;
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(block.description(), (List)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(block.getStepList()).toList().map((Function1 & Serializable & scala.Serializable)stepState -> this.transformStepState((StepState)stepState), List$.MODULE$.canBuildFrom()), isParallel);
                nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    private boolean transformBlockState$default$2() {
        return false;
    }

    private String getTaskDescription(Deployment deployment) {
        String string;
        Deployment.DeploymentType deploymentType = deployment.getDeploymentType();
        if (Deployment.DeploymentType.INITIAL.equals(deploymentType)) {
            string = "deployed to";
        } else if (Deployment.DeploymentType.UPDATE.equals(deploymentType)) {
            string = "updated on";
        } else if (Deployment.DeploymentType.UNDEPLOYMENT.equals(deploymentType)) {
            string = "un-deployed from";
        } else {
            throw new MatchError((Object)deploymentType);
        }
        String typeRelatedPart = string;
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application '", "' will be ", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deployedApp.getVersion().getId(), typeRelatedPart, deployedApp.getEnvironment().getId()}));
    }

    public PreviewResponse preview(Definition definition) {
        String string = definition.kind();
        String string2 = Constants$Kinds$.MODULE$.DEPLOYMENT();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot preview '", "' spec. Only '", "' spec kind is supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{definition.kind(), Constants$Kinds$.MODULE$.DEPLOYMENT()})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        DeploymentSpec spec = (DeploymentSpec)definition.spec();
        Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
        TaskPreviewBlock taskPreviewBlock = this.deploymentService.taskPreviewBlock(deployment);
        List<PreviewResponse.TaskPreviewItem> taskPreviewItems = this.transformBlockState(taskPreviewBlock.getBlock(), this.transformBlockState$default$2());
        return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.getTaskDescription(deployment), taskPreviewItems)));
    }

    public static final /* synthetic */ boolean $anonfun$transformBlockState$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public PreviewService(DeploymentService deploymentService, DeploymentPreparationService deploymentPreparationService) {
        this.deploymentService = deploymentService;
        this.deploymentPreparationService = deploymentPreparationService;
    }
}

