/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork.TextProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractDeployitConfigurator
extends AbstractTaskConfigurator {
    public static final String DEPLOYIT_URL = "deployitServerUrl";
    public static final String DEPLOYIT_USERNAME = "deployitUsername";
    public static final String DEPLOYIT_PASSWORD = "deployitPassword";
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private static final Logger log = Logger.getLogger(AbstractDeployitConfigurator.class);
    protected TextProvider textProvider;
    protected UIConfigSupport uiConfigSupport;
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.of((Object)"deployitServerUrl", (Object)"deployitUsername", (Object)"deployitPassword");

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
        context.put(DEPLOYIT_URL, "http://localhost:4516");
        context.put(DEPLOYIT_USERNAME, "admin");
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        log.debug((Object)"AbstractDeployitConfigurator.calculateRequirements");
        String executableLabel = (String)taskDefinition.getConfiguration().get("selectedExecutable");
        RequirementImpl executableReq = new RequirementImpl("system.builder.myExecutable." + executableLabel, true, ".*");
        String jdkLabel = (String)taskDefinition.getConfiguration().get("buildJdk");
        RequirementImpl jdkReq = new RequirementImpl("system.builder.jdk." + jdkLabel, true, ".*");
        return ImmutableSet.of((Object)executableReq, (Object)jdkReq);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        log.debug((Object)"AbstractDeployitConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        this.validateAttribute(params, errorCollection, DEPLOYIT_URL, "deployit.url.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_USERNAME, "deployit.username.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_PASSWORD, "deployit.password.error");
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        log.debug((Object)"AbstractDeployitConfigurator.generateTaskConfigMap");
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, Iterables.concat(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
        this.doGenerateTaskConfigMap(params, config);
        log.debug((Object)("AbstractDeployitConfigurator.generateTaskConfigMap config " + config));
        return config;
    }

    protected void doGenerateTaskConfigMap(ActionParametersMap params, Map<String, String> config) {
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
    }

    protected void validateAttribute(ActionParametersMap params, ErrorCollection errorCollection, String attribute, String errorKey) {
        if (StringUtils.isEmpty((String)params.getString(attribute))) {
            errorCollection.addError(attribute, this.textProvider.getText(errorKey));
        }
    }

    public void setTextProvider(TextProvider textProvider) {
        log.debug((Object)"DeployUpgradeConfigurator.setTextProvider");
        this.textProvider = textProvider;
    }

    protected Set<String> getExtraFieldsToCopy() {
        return Collections.emptySet();
    }

    public void setUiConfigBean(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

