/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.ci.bamboo.configuration.AbstractDeployitConfigurator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImportAppConfigurator
extends AbstractDeployitConfigurator {
    private static final Logger log = Logger.getLogger(ImportAppConfigurator.class);
    public static final String DEPLOYIT_DAR_PATH = "deployitDarPath";
    public static final String DEPLOYIT_EXTENSION = "deployitExtension";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.of((Object)"deployitDarPath", (Object)"deployitExtension");

    @Override
    protected Set<String> getExtraFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(DEPLOYIT_EXTENSION, "dar");
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        log.debug((Object)"ImportAppConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        if (StringUtils.isBlank((String)params.getString(DEPLOYIT_DAR_PATH)) && StringUtils.isBlank((String)params.getString(DEPLOYIT_EXTENSION))) {
            errorCollection.addError(DEPLOYIT_DAR_PATH, this.textProvider.getText("deployit.import.error"));
            errorCollection.addError(DEPLOYIT_EXTENSION, this.textProvider.getText("deployit.import.error"));
        }
    }
}

