/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployitCliCallback;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.Descriptors;
import hudson.model.Hudson;
import hudson.util.Secret;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployitCliTemplate {
    private DeployitCli deployitCli;
    private String deployitServerUrl;
    private Credential credential;

    public DeployitCliTemplate(String deployitServerUrl, Credential credential) {
        this.deployitServerUrl = deployitServerUrl;
        this.credential = credential;
    }

    public DeployitCliTemplate(String deployitServerUrl, String username, Secret password) {
        this.deployitServerUrl = deployitServerUrl;
        this.credential = new Credential(username, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T perform(DeployitCliCallback<T> callback) {
        Thread currentThread = Thread.currentThread();
        ClassLoader origClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader pluginClassLoader = Hudson.getInstance().getPluginManager().getPlugin((String)"deployit-plugin").classLoader;
            currentThread.setContextClassLoader(pluginClassLoader);
            T t = callback.call(this.getCli());
            return t;
        }
        finally {
            currentThread.setContextClassLoader(origClassLoader);
        }
    }

    private synchronized DeployitCli getCli() {
        return new DeployitCli(new ConnectionOptions(this.deployitServerUrl, this.credential.username, this.credential.password.getPlainText()));
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public String getDeployitServerUrl() {
        return this.deployitServerUrl;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public Descriptors getDescriptors() {
        return this.perform(new DeployitCliCallback<Descriptors>(){

            @Override
            public Descriptors call(DeployitCli cli) {
                return cli.getDescriptors();
            }
        });
    }
}

