package com.xebialabs.deployit.cli;

import com.google.common.collect.Maps;
import org.python.core.Py;
import org.python.core.PySystemState;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.Map;

public class ScriptEngineBuilder {

    private Map<String, Object> attributes = Maps.newHashMap();

    public ScriptEngine build(CliOptions options) {
        if (!options.getScriptArgs().isEmpty()) {
            PySystemState engineSys = new PySystemState();
            if (options.interpretSourceFile()) {
                engineSys.argv.clear();
                engineSys.argv.append(Py.newString(options.getSourceFileName()));
            }
            for (String s : options.getScriptArgs()) {
                engineSys.argv.append(Py.newString(s));
            }
            Py.setSystemState(engineSys);
        }
        final ScriptEngineManager engineManager = new ScriptEngineManager();
        final ScriptEngine jythonEngine = engineManager.getEngineByName("python");

        if (jythonEngine == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }

        registerAttributes(jythonEngine);
        return jythonEngine;
    }

    private void registerAttributes(ScriptEngine jythonEngine) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            jythonEngine.put(entry.getKey(), entry.getValue());
        }
    }

    public void put(String name, Object value) {
        attributes.put(name, value);
    }
}
