package com.xebialabs.deployit.cli.api.internal;

import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Helper that can both upload packages from the client and import packages on the server.
 */
public class ImportHelper {

    /**
     * Check whether the packageToImport parameter refers to a file by checking for its existence.
     * If it is not a file, it should be a package in the importablePackages directory on the server, and should be
     * importable from there.
     *
     * @param proxy
     * @param packageToImport
     * @return
     */
    public static RepositoryObject doImport(ImportablePackageProxy proxy, String packageToImport) {
        Response response;
        try {
            URL url = new URL(packageToImport);
            if (url.getProtocol().equals("file")) {
                response = processFilePath(proxy,url.getFile());
            } else {
                response = proxy.importPackageFromUrl(url.toString());
            }
        } catch (MalformedURLException e) {
           response = processFilePath(proxy,packageToImport);
        }

        return new ResponseExtractor(response).getEntity();
    }

    private static Response processFilePath(ImportablePackageProxy proxy, String path) {
        final File file = new File(path);
        final Response response;
        if (file.exists()) {
            final FileUpload fileUpload = new FileUpload();
            try {
                fileUpload.setFileData(FileUtils.readFileToByteArray(file));
                response = proxy.importUploadedPackage(fileUpload);
            } catch (IOException e) {
                logger.error("The file {} exists, but could not be read for upload.");
                return null;
            }
        } else {
            response = proxy.importPackage(path);
        }
        return response;

    }

    private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);
}
