package com.xebialabs.deployit.cli.help;

import static java.lang.String.format;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

import com.xebialabs.deployit.cli.Cli.Authentication;

public class ExportHelp {

	private ExportHelp(){		
	};
	
	public static final String parseDateFormat(final String dateToFormat, final String parseFormat, final String resultFormat){
		try {
			final DateFormat parseDateFormat = new SimpleDateFormat(parseFormat);
			parseDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
			final DateFormat resultDateFormat = new SimpleDateFormat(resultFormat);
			resultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
			return resultDateFormat.format(parseDateFormat.parse(dateToFormat));
		} catch (ParseException parseException) {
			throw new IllegalArgumentException(format("Cannot parse date; should be in format %s", parseFormat));
		}
	}
	
	public static final String encodeURIDateFormat(final String date, final String charSet){	
		try {
			return URLEncoder.encode(date, charSet);	
		} catch (UnsupportedEncodingException parseException) {
			throw new IllegalArgumentException(format("Cannot parse date because of unsupported encoding; should be in %s encoding", charSet));
		}
	}
	
	public static final long writeResourceToLocalFile(final Authentication authentication, final String filePath, final String resourceURL) throws IOException{
		FileOutputStream outputResourceFile = null;
		try {
			HttpClient httpClient = authentication.getHttpClient();
			GetMethod getMethod = new GetMethod(resourceURL);
			int responseCode = httpClient.executeMethod(getMethod);
			if (responseCode == 200) {
				long bytesWritten = 0;
				outputResourceFile = new FileOutputStream(filePath);
				FileChannel fileChannel = outputResourceFile.getChannel();
				if (fileChannel.isOpen()){
					ByteBuffer byteBuffer = ByteBuffer.allocate(50000);
					ReadableByteChannel resourceStream = Channels.newChannel(getMethod.getResponseBodyAsStream());
					while (resourceStream.read(byteBuffer) > 0){
						byteBuffer.flip();
						fileChannel.write(byteBuffer);
						fileChannel.force(false);
						byteBuffer.clear();
					};
					bytesWritten = fileChannel.size();
					fileChannel.close();
					resourceStream.close();
				}
				return bytesWritten;
			} else if (responseCode == 401 || responseCode == 403) {
				throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
			} else {
				throw new IllegalStateException("Could contact the server at " + httpClient.getHostConfiguration().getHost() + " but received an HTTP error code, " + responseCode);
			}
		} catch (IOException outputFileException) {
			throw new IOException(format("The file at %s could not be created.", filePath));
		} finally {
			if (outputResourceFile != null){
				outputResourceFile.close();
			}
		}
	}
}
