package com.xebialabs.deployit.cli.rest;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpUriRequest;
import com.google.common.io.CharStreams;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;

/**
 * This class contains the logic for executing requests that need to go around RestEasy layer.
 */
public class RequestExecutor {

    private DeployitCommunicator communicator;

    public RequestExecutor(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public String execute(HttpUriRequest req) {
        try {
            HttpResponse response = communicator.execute(req);

            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                return getContent(response);
            } else {
                StringBuilder errorMessage = new StringBuilder(response.getStatusLine().getReasonPhrase());
                try {
                    String responseContent = getContent(response);
                    if (!responseContent.isEmpty()) {
                        errorMessage.append(": ").append(responseContent);
                    }
                } catch (RuntimeException ignored) {}

                throw new RuntimeException(errorMessage.toString());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }



    private String getContent(HttpResponse response) {
        try(Reader is = new InputStreamReader(response.getEntity().getContent())) {
            return CharStreams.toString(is);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
