/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.WorkerInfo;
import java.util.Collections;
import java.util.List;

@CliObject(name="workers")
@ClassHelp(description="Access to the task execution workers of XL Deploy")
public class WorkersClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public WorkersClient() {
    }

    public WorkersClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Lists the active task execution workers.", returns="A list of workers with id, address and state")
    public List<WorkerInfo> list() {
        return this.proxies.getWorkers().listWorkers(null, null);
    }

    @MethodHelp(description="Shutdown worker.", parameters={@ParameterHelp(name="workerId", description="The id of the worker.")})
    public void shutdown(Integer workerId) {
        this.proxies.getWorkers().shutdownWorker(workerId);
    }

    @MethodHelp(description="Remove worker.", parameters={@ParameterHelp(name="workerId", description="The id of the worker.")})
    public void remove(Integer workerId) {
        this.proxies.getWorkers().removeWorker(workerId);
    }

    @MethodHelp(description="Shutdown workers by their address.", parameters={@ParameterHelp(name="workerAddresses", description="The addresses of the worker.")})
    public void shutdown(List<String> workerAddresses) {
        this.proxies.getWorkers().shutdownWorkers(workerAddresses);
    }

    @MethodHelp(description="Shutdown all workers")
    public void shutdownAll() {
        this.shutdown(Collections.emptyList());
    }

    @MethodHelp(description="Restore ghost tasks and return their IDs from the workers.", returns="A list of task IDs of restored ghost tasks")
    public List<String> restoreGhostTasks() {
        return this.proxies.getWorkers().reregisterGhostTasks();
    }
}

