/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.planning.ReferencedWebserverContributor;
import com.xebialabs.deployit.community.wasext.task.CellTasks;
import com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import java.util.Set;

public class GenerateAndPropagateWebserverPlugin
extends ReferencedWebserverContributor {
    private static final String CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY = "updateGlobalPlugin";
    private static final String WEBSERVER_UPDATE_PLUGIN_PROPERTY = "updatePlugin";

    @Contributor
    public void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext ctx) {
        this.filterDeltas(deltas.getDeltas());
        Set<ManagedWebServer> referencedWebservers = this.getReferencedWebservers();
        for (Cell cell : this.getReferencedCells(referencedWebservers)) {
            if (!Boolean.TRUE.equals(cell.getProperty(CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY))) continue;
            CellTasks.updateGlobalPlugin(cell, ctx);
        }
        for (ManagedWebServer webserver : referencedWebservers) {
            if (!Boolean.TRUE.equals(webserver.getProperty(WEBSERVER_UPDATE_PLUGIN_PROPERTY))) continue;
            ManagedWebServerTasks.generatePlugin(webserver, ctx);
            ManagedWebServerTasks.propagatePlugin(webserver, ctx);
        }
    }

    private Iterable<Cell> getReferencedCells(Set<ManagedWebServer> webservers) {
        return Iterables.transform(webservers, (Function)new Function<ManagedWebServer, Cell>(){

            public Cell apply(ManagedWebServer input) {
                return input.getNode().getCell();
            }
        });
    }
}

