package com.xebialabs.deployit.community.wasext.step;

import static java.lang.String.format;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;

@SuppressWarnings("serial")
public class PluginConfigurationCopyStep implements DeploymentStep {

	private ManagedWebServer webserver;
	private int copyStepOrder;
	private final String pluginSrcFilePath;
	private final String pluginDestFilePath;

	public PluginConfigurationCopyStep(int order, ManagedWebServer webserver) {
		this.copyStepOrder = order;
		this.webserver = webserver;
		pluginSrcFilePath = webserver.getNode().getCell().getWasHome() + "/config/cells/" + webserver.getNode().getCell().getCellName() + "/nodes/"
		        + webserver.getNode().getNodeName() + "/servers/" + webserver.getName().trim() + "/plugin-cfg.xml";
		pluginDestFilePath = webserver.getProperty("pluginConfigurationPath");
	}

	@Override
	public String getDescription() {
		return String.format("Copy WebSphere plugin configuration file for unmanaged webserver " + webserver.getName());
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
		OverthereConnection localConnection = webserver.getNode().getCell().getHost().getConnection();
		OverthereConnection remoteHostConnection = ((Host)webserver.getProperty("host")).getConnection();
		try {
			final OverthereFile source = localConnection.getFile(pluginSrcFilePath);
			final OverthereFile remote = remoteHostConnection.getFile(pluginDestFilePath);
			ctx.logOutput(format("Copying generated plugin configuration file from %s to %s", pluginSrcFilePath, pluginDestFilePath));
			OverthereFileCopier.copy(source, remote);
		} finally {
			Closeables.closeQuietly(localConnection);
			Closeables.closeQuietly(remoteHostConnection);
		}
		return Result.Success;
	}

	@Override
    public int getOrder() {
	    return copyStepOrder;
    }
}
