
def noneOrEmpty(value):
    return (value is None) or (value == '')

def isWebModule(id):
    return id.find('#WebModuleDeployment_') != -1

def toConfigIdList(spaceSeparatedIdList):
    # input format '[id id id ...]'
    # strings.strip(chars) not available in Python 2.1
    return spaceSeparatedIdList.replace('[', '').replace(']', '').split(' ')

installArgs = ['-appname', deployed.name]

# if this is not a WAR deployment, the contextroot property will not be present on the deployed
if hasattr(deployed, 'contextRoot'):
    installArgs.extend(['-contextroot', deployed.contextRoot])

targets = "WebSphere:cell=%s,%s=%s" % (deployed.container.cellName, deployed.container.wasTargetType, deployed.container.name)

# if this is an EJB deployment, the webServers property will not be present on the deployed
if hasattr(deployed, 'webServers'):
    for ws in deployed.webServers:
        targets += "+WebSphere:cell=%s,node=%s,server=%s" % (ws.node.cellName,ws.node.name,ws.name)

servermappings = []
servermappings.append(['.*', '.*', targets])
installArgs.extend(['-MapModulesToServers', servermappings])

vhostmappings = []
if hasattr(deployed, 'virtualHost') and deployed.virtualHost != None:
    vhostmappings.append(['.*', '.*', deployed.virtualHost.name])
else:
    vhostmappings.append(['.*', '.*', 'default_host'])
installArgs.extend(['-MapWebModToVH', vhostmappings])

if len(deployed.sharedLibraries) > 0:
    sharedLibraryMappings = []
    for l in deployed.sharedLibraries:
        sharedLibraryMappings.append(['.*', '.*', l.name])
    installArgs.extend(['-MapSharedLibForMod', sharedLibraryMappings])
    
if hasattr(deployed, 'roleMappings'):
    roleMappings = []
    for role,group in deployed.roleMappings.items():
        if group == 'Everyone':
            roleMappings.append([role, 'Yes', 'No', '', ''])
        else:
            roleMappings.append([role, 'No', 'No', '', group])
    if len(roleMappings) > 0:
        installArgs.extend(['-MapRolesToUsers', roleMappings])

# if this is an EJB deployment, the preCompileJsps property will not be present on the deployed
if hasattr(deployed, 'preCompileJsps') and deployed.preCompileJsps:
    installArgs.extend(['-preCompileJSPs','-JSPCompileOptions', [['.*', '.*', 'jspcp', 'Yes', 15, 'No']]])

# optionally, specify a custom directory to store the installed module (if set on the was.Container)
if hasattr(deployed.container, 'moduleDestination') and deployed.container.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.container.moduleDestination])

# optionally, specify a custom directory to store the installed module (if set on the was.Module)
if hasattr(deployed, 'moduleDestination') and deployed.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.moduleDestination])

if hasattr(deployed, 'additionalInstallFlags'):
    for f in deployed.additionalInstallFlags:
        installArgs.append(f)

print "Deploying application", deployed.name, "with args: %s" % (installArgs)
AdminApp.install(deployed.file, installArgs)

deployment = AdminConfig.getid('/Deployment:%s' % (deployed.name))
deployedObject = AdminConfig.showAttribute(deployment, 'deployedObject')

# if this is not an EAR deployment, the startingWeight property will not be present on the deployed
if hasattr(deployed, 'startingWeight'):
    AdminConfig.modify(deployedObject, [['startingWeight', str(deployed.startingWeight)]])

if hasattr(deployed, 'classloaderMode'):
    if not(noneOrEmpty(deployed.classloaderMode)):
        classLoaderAttr = AdminConfig.showAttribute(deployedObject, 'classloader')
        AdminConfig.modify(classLoaderAttr, [['mode', deployed.classloaderMode]])

if hasattr(deployed, 'webModuleSessionTimeout'):
    if not(noneOrEmpty(deployed.webModuleSessionTimeout)):
        for module in toConfigIdList(AdminConfig.showAttribute(deployedObject, 'modules')):
            if isWebModule(module):
                AdminConfig.create('WebModuleConfig', module, [['sessionManagement', [['enable', 'true'], ['tuningParams', [['invalidationTimeout', str(deployed.webModuleSessionTimeout)]]]]]])
