/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.planning.ReferencedWebserverContributor;
import com.xebialabs.deployit.community.wasext.task.CellTasks;
import com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import java.util.Set;

public class GenerateAndPropagateWebserverPlugin
extends ReferencedWebserverContributor {
    private static final String CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY = "updateGlobalPlugin";
    private static final String WEBSERVER_UPDATE_PLUGIN_PROPERTY = "updatePlugin";

    @Contributor
    public void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        this.filterDeltas(deltas.getDeltas());
        Set<ManagedWebServer> set = this.getReferencedWebservers();
        for (Cell cell : GenerateAndPropagateWebserverPlugin.getReferencedCells(set)) {
            if (!Boolean.TRUE.equals(cell.getProperty(CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY))) continue;
            CellTasks.updateGlobalPlugin(cell, deploymentPlanningContext);
        }
        for (ManagedWebServer managedWebServer : set) {
            if (!Boolean.TRUE.equals(managedWebServer.getProperty(WEBSERVER_UPDATE_PLUGIN_PROPERTY))) continue;
            ManagedWebServerTasks.generatePlugin(managedWebServer, deploymentPlanningContext);
            ManagedWebServerTasks.propagatePlugin(managedWebServer, deploymentPlanningContext);
        }
    }

    private static Iterable<Cell> getReferencedCells(Set<ManagedWebServer> set) {
        return Iterables.transform(set, (Function)new Function<ManagedWebServer, Cell>(){

            public Cell apply(ManagedWebServer managedWebServer) {
                return managedWebServer.getNode().getCell();
            }
        });
    }
}

