/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import java.util.Map;

public class ClusterTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";

    public static void stop(Cluster cluster, DeploymentPlanningContext deploymentPlanningContext) {
        ClusterTasks.stop(cluster, deploymentPlanningContext, (Integer)cluster.getProperty(STOP_ORDER_PROPERTY));
    }

    protected static void stop(Cluster cluster, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((DeploymentStep)new PythonDeploymentStep(n, (PythonManagingContainer)cluster.getCell(), (String)cluster.getProperty(STOP_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)cluster), String.format("Stop cluster '%s'", cluster.getName())));
    }

    public static void start(Cluster cluster, DeploymentPlanningContext deploymentPlanningContext) {
        ClusterTasks.start(cluster, deploymentPlanningContext, (Integer)cluster.getProperty(START_ORDER_PROPERTY));
    }

    protected static void start(Cluster cluster, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((DeploymentStep)new PythonDeploymentStep(n, (PythonManagingContainer)cluster.getCell(), (String)cluster.getProperty(START_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)cluster), String.format("Start cluster '%s'", cluster.getName())));
    }

    public static void restart(Cluster cluster, DeploymentPlanningContext deploymentPlanningContext) {
        int n = (Integer)cluster.getProperty(START_ORDER_PROPERTY);
        ClusterTasks.stop(cluster, deploymentPlanningContext, n - 2);
        ClusterTasks.start(cluster, deploymentPlanningContext, n);
    }
}

