/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Server;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedServer
extends BaseContainer
implements Server {
    protected final Map<String, Object> context = ImmutableMap.of((Object)"container", (Object)((Object)this));
    @Property(asContainment=true, label="WebSphere node", description="Node on which the server runs")
    private NodeAgent node;
    @Property(required=true, defaultValue="was/server/restart-server.py", hidden=true)
    private String restartServerScript;

    public NodeAgent getNode() {
        return this.node;
    }

    public void setNode(NodeAgent node) {
        this.node = node;
    }

    public Cell getCell() {
        return this.getNode().getCell();
    }

    public Host getHost() {
        return this.getCell().getHost();
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    public String getCellName() {
        return this.getCell().getName();
    }

    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        return this.getNode().getName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this.getNode());
    }

    public String getContainmentPath() {
        return "/Node:" + this.getNodeName() + "/Server:" + this.getName();
    }

    public String getWasConfigIdType() {
        return "Server";
    }

    public String getWasTargetType() {
        return "server";
    }

    public String getShortTypeDescription() {
        return "managed server";
    }

    public List<String> getApplicationManagerObjectNames() {
        String appMgrObjectName = "cell=" + this.getCell().getCellName() + ",node=" + this.getNode().getName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(appMgrObjectName);
    }

    public List<Step> controlTaskDispatch(String name) {
        PropertyDescriptor scriptProperty = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(name + "PythonScript");
        Preconditions.checkArgument((scriptProperty != null ? 1 : 0) != 0, (String)"Control task script property '%sPythonScript' not defined for CI type %s", (Object[])new Object[]{name, this.getType()});
        return ImmutableList.of((Object)new PythonDeploymentStep(1, this.getManagingContainer(), (String)scriptProperty.get((ConfigurationItem)this) + ".py", this.context, "Executing " + name));
    }
}

