#

providerContainmentPath = '%s/WorkManagerProvider:%s' % (deployed.container.containmentPath, deployed.provider)
providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot find WorkManagerProvider in scope '%s'" % (deployed.container.name))

args = toAdminConfigArgs(deployed.getExposedProperties(True))


# do not use toAdminConfigArgs as we need some translations here.
# for workReqQFullAction we have Block == 0 ; Fail == 1
if deployed.workReqQFullAction == 'Block':
	workReqQFullAction = 0
elif deployed.workReqQFullAction == 'Fail':
	workReqQFullAction = 1
	
# service names possibilities are: AppProfileService UserWorkArea com.ibm.ws.i18n security
serviceNames = ""
if deployed.ServiceNames.security:
	serviceNames = serviceNames + "security "
if deployed.ServiceNames.applicationProfilingService:
	serviceNames = serviceNames + "AppProfileService "
if deployed.ServiceNames.internationalization:
	serviceNames = serviceNames + "com.ibm.ws.i18n "
if deployed.ServiceNames.workArea:
	serviceNames = serviceNames + "UserWorkArea "
if serviceNames != "":
	serviceNames = serviceNames[:-1] 

if deployed.isGrowable:
	growable = "true"
else:
	growable = "false"


args.append(['workReqQFullAction', str(workReqQFullAction)])
args.append(['isGrowable', growable])
args.append(['serviceNames', serviceNames])

print "Creating work manager with provider %s and args %s " % (deployed.provider, args)
AdminConfig.create('WorkManagerInfo', providerId, args)
