def toServerIds(deployed):
    ### this function is *not found* if defined at top-level
    def toServerId(member):
            nodeName = AdminConfig.showAttribute(member,'nodeName')
            memberName = AdminConfig.showAttribute(member,'memberName')
            return AdminConfig.getid("/Node:%s/Server:%s" % (nodeName, memberName))

    containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find config id for container "+ deployed.container.containmentPath);
    if containerId.find('ServerCluster') > 0:
            return [toServerId(member) for member in AdminConfig.list("ClusterMember", containerId).splitlines()]
    else:
            return [containerId]

# Create Listener Port
def createListenerPort(containerId, deployed):
    mls = AdminConfig.list('MessageListenerService', containerId)
    args = toAdminConfigArgs(deployed.getExposedProperties(True))


    print "Creating Listener Port in %s with args %s " % (containerId, args)
    newListener = AdminConfig.create('ListenerPort', mls, args)
    if deployed.initialStateStarted == True:
        AdminConfig.create('StateManageable', newListener, [['initialState', 'START']])
    else:
        AdminConfig.create('StateManageable', newListener, [['initialState', 'STOP']])

[createListenerPort(id,deployed) for id in toServerIds(deployed)]
