
# verify that the auth aliasses are indeed defined on this cell:
interEngineAuthAlias = deployed.interEngineAuthAlias.name
mediationsAuthAlias = deployed.mediationsAuthAlias.name

AdminTask.createSIBus('[-bus %s -busSecurity true -interEngineAuthAlias %s -mediationsAuthAlias %s -description "%s" -protocol %s]' % (deployed.busName, interEngineAuthAlias, mediationsAuthAlias, deployed.description, deployed.protocol))

if deployed.transport.bootstrapTunneledSecureMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain BootstrapTunneledSecureMessaging]' % deployed.busName)

allowedProtocols = ''
if deployed.transport.bootstrapBasicMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain BootstrapBasicMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'BootstrapBasicMessaging, '
if deployed.transport.bootstrapSecureMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain BootstrapSecureMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'BootstrapSecureMessaging, '
if deployed.transport.bootstrapTunneledMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain BootstrapTunneledMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'BootstrapTunneledMessaging, '
if deployed.transport.bootstrapTunneledSecureMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain BootstrapTunneledSecureMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'BootstrapTunneledSecureMessaging, '
if deployed.transport.outboundBasicMQLink:
	AdminTask.addSIBPermittedChain('[-bus %s -chain OutboundBasicMQLink]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'OutboundBasicMQLink, '
if deployed.transport.outboundSecureMQLink:
	AdminTask.addSIBPermittedChain('[-bus %s -chain OutboundSecureMQLink]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'OutboundSecureMQLink, '
if deployed.transport.outboundBasicWMQClient:
	AdminTask.addSIBPermittedChain('[-bus %s -chain OutboundBasicWMQClient]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'OutboundBasicWMQClient, '
if deployed.transport.inboundBasicMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain InboundBasicMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'InboundBasicMessaging, '
if deployed.transport.inboundSecureMessaging:
	AdminTask.addSIBPermittedChain('[-bus %s -chain InboundSecureMessaging]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'InboundSecureMessaging, '
if deployed.transport.inboundSecureMQLink:
	AdminTask.addSIBPermittedChain('[-bus %s -chain InboundSecureMQLink]' % deployed.busName)
	allowedProtocols = allowedProtocols + 'InboundSecureMQLink, '

# cancel creation if protocol is not an allowed one
if allowedProtocols.find(deployed.protocol) == -1:
	print 'ERROR Specified protocol "' + deployed.protocol + '" is not found in the list of permitted protocols: ' + allowedProtocols
	print '   either add the protocol to the permitted ones, or specify a protocol in the permitted protocol list'
	sys.exit(1)

print 'Created a SI bus named ' + deployed.busName