package com.xebialabs.deployit.rest.test.api

import datasets._
import javax.ws.rs.core.Response
import javax.ws.rs.{ PathParam, POST, Path }
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory
import org.springframework.stereotype.Component

@Component
@Path("/data-generator")
class DataGenerator {

  val sets: Map[String, DataSet] = Set(SampleSet, FillRepository).map { s: DataSet =>
    (s.name(), s)
  }.toMap

  @POST
  @Path("/{set}")
  def generate(@PathParam("set") dataSet: String): Response = {
    sets.get(dataSet) match {
      case None => ResponseFactory.serverError().build()
      case Some(x) => {
        x.generateSet()
        ResponseFactory.noContent().build()
      }
    }
  }
}

trait DataSet extends Generator {
  def name(): String
  def generateSet()
}