package com.xebialabs.deployit.plugin;

import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.TaskArchive;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class TestServiceHolder {

	private static final AtomicReference<ImporterService> importerService = new AtomicReference<ImporterService>();
	private static final AtomicReference<UserService> userService = new AtomicReference<UserService>();
	private static final AtomicReference<ExecutionEngine> engine = new AtomicReference<ExecutionEngine>();
	private static final AtomicReference<TaskArchive> taskArchive = new AtomicReference<TaskArchive>();
	private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference<WorkDirFactory>();

	@Autowired
	public TestServiceHolder(ImporterService importerService, UserService userService, ExecutionEngine engine, TaskArchive taskArchive, WorkDirFactory workDirFactory) {
		TestServiceHolder.importerService.set(importerService);
		TestServiceHolder.userService.set(userService);
		TestServiceHolder.engine.set(engine);
		TestServiceHolder.taskArchive.set(taskArchive);
		TestServiceHolder.workDirFactory.set(workDirFactory);
	}

	public static ImporterService getImporterService() {
		return TestServiceHolder.importerService.get();
	}

	public static UserService getUserService() {
		return TestServiceHolder.userService.get();
	}

	public static ExecutionEngine getExecutionEngine() {
		return TestServiceHolder.engine.get();
	}

	public static TaskArchive getTaskArchive() {
		return TestServiceHolder.taskArchive.get();
	}

	public static WorkDirFactory getWorkDirFactory() {
		return TestServiceHolder.workDirFactory.get();
	}
}
