/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.rest.test.api;

import com.google.common.collect.Multimap;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.TestServiceHolder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.rest.test.api.Generator;
import com.xebialabs.deployit.rest.test.api.Generator$;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.service.deployment.RepositoryUpdateTrigger;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public abstract class Generator$class {
    public static void user(Generator $this, String name) {
        TestServiceHolder.getUserService().create(name, name);
    }

    public static void role(Generator $this, String name, List principals) {
        RoleService service = TestServiceHolder.getRoleService();
        java.util.List assignments = service.readRoleAssignments();
        Role role = new Role(name);
        role.getPrincipalsAssigned().addAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)principals));
        assignments.add(role);
        service.writeRoleAssignments(assignments);
    }

    public static void create(Generator $this, Function1 c) {
        ChangeSet changeSet = new ChangeSet();
        Generator.Creator creator = new Generator.Creator($this, changeSet);
        c.apply((Object)creator);
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
        creator.cleanUp();
    }

    private static Object read(Generator $this, String id, WorkDir workDir) {
        return RepositoryServiceHolder.getRepositoryService().read(id, workDir);
    }

    public static void grant(Generator $this, String role, String perm, String onCi) {
        PermissionEditor editor = TestServiceHolder.getPermissionEditor();
        Multimap permissions = editor.readPermissions(onCi);
        permissions.put((Object)TestServiceHolder.getRoleService().getRoleForRoleName(role), (Object)Permission.find((String)perm));
        editor.editPermissions(onCi, permissions);
    }

    public static String grant$default$3(Generator $this, String role) {
        return "";
    }

    public static void task(Generator $this, Function1 c) {
        ArchivedTask taskForReporting = new ArchivedTask();
        taskForReporting.getMetadata().put("taskType", TaskType.INITIAL.name());
        taskForReporting.setOwner("admin");
        c.apply((Object)taskForReporting);
        TestServiceHolder.getTaskArchive().archive((TaskWithSteps)taskForReporting);
    }

    public static String deploy(Generator $this, String dpId, String envId) {
        WorkDir workDir = TestServiceHolder.getWorkDirFactory().newWorkDir();
        DeploymentPackage dp = (DeploymentPackage)Generator$class.read($this, dpId, workDir);
        Environment env2 = (Environment)Generator$class.read($this, envId, workDir);
        scala.collection.mutable.Set set = Generator$class.generateDeployeds($this, dp, env2);
        DeltaSpecification specification = Generator$class.createSpecification($this, dp, env2, set);
        java.util.List plan = $this.tester().resolvePlan(specification);
        CountDownLatch latch$1 = new CountDownLatch(1);
        TaskSpecification specification1 = new TaskSpecification("deployment", "admin", plan);
        specification1.getMetadata().put("environment", env2.getName());
        specification1.getMetadata().put("environment_id", env2.getId());
        specification1.getMetadata().put("application", dp.getApplication().getName());
        specification1.getMetadata().put("version", dp.getName());
        specification1.getMetadata().put("taskType", TaskType.INITIAL.name());
        specification1.getListeners().add(new ExecutionStateListener($this, latch$1){
            private final CountDownLatch latch$1;

            public void taskStateChanged(TaskExecutionStateEvent event) {
                block3: {
                    block2: {
                        TaskExecutionState taskExecutionState = event.currentState();
                        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
                        if (!(taskExecutionState == null ? taskExecutionState2 != null : !taskExecutionState.equals(taskExecutionState2))) break block2;
                        TaskExecutionState taskExecutionState3 = event.currentState();
                        TaskExecutionState taskExecutionState4 = TaskExecutionState.STOPPED;
                        if (taskExecutionState3 != null ? !taskExecutionState3.equals(taskExecutionState4) : taskExecutionState4 != null) break block3;
                    }
                    this.latch$1.countDown();
                }
            }

            public void stepStateChanged(StepExecutionStateEvent event) {
            }
            {
                this.latch$1 = countDownLatch;
            }
        });
        specification1.getListeners().add(new RepositoryUpdateTrigger(specification));
        String taskId = TestServiceHolder.getExecutionEngine().register(specification1);
        TestServiceHolder.getExecutionEngine().execute(taskId);
        latch$1.await();
        TaskExecutionState taskExecutionState = TestServiceHolder.getExecutionEngine().retrieve(taskId).getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            TestServiceHolder.getExecutionEngine().archive(taskId);
        }
        return taskId;
    }

    private static scala.collection.mutable.Set generateDeployeds(Generator $this, DeploymentPackage dp, Environment env$1) {
        DeployedGenerator deployedGenerator$1 = new DeployedGenerator(RepositoryServiceHolder.getRepositoryService(), new TypeCalculator());
        ConsolidatedDictionary dict$1 = ConsolidatedDictionary.create((Collection)env$1.getDictionaries());
        HashSet set$1 = new HashSet();
        JavaConversions$.MODULE$.asScalaSet(dp.getDeployables()).foreach((Function1)new Serializable($this, env$1, deployedGenerator$1, dict$1, (scala.collection.mutable.Set)set$1){
            public static final long serialVersionUID;
            private final Environment env$1;
            public final DeployedGenerator deployedGenerator$1;
            public final ConsolidatedDictionary dict$1;
            public final scala.collection.mutable.Set set$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Deployable d$1) {
                JavaConversions$.MODULE$.asScalaSet(this.env$1.getMembers()).foreach((Function1)new Serializable(this, d$1){
                    public static final long serialVersionUID;
                    private final Generator$.anonfun.generateDeployeds.1 $outer;
                    private final Deployable d$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Container c) {
                        Deployed deployed = this.$outer.deployedGenerator$1.generateMostSpecificDeployed(this.d$1, c, this.$outer.dict$1);
                        return deployed == null ? BoxedUnit.UNIT : this.$outer.set$1.$plus$eq((Object)deployed);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.d$1 = deployable;
                    }
                });
            }
            {
                this.env$1 = environment2;
                this.deployedGenerator$1 = deployedGenerator;
                this.dict$1 = consolidatedDictionary;
                this.set$1 = set;
            }
        });
        return set$1;
    }

    private static DeltaSpecification createSpecification(Generator $this, DeploymentPackage dp, Environment env2, scala.collection.mutable.Set set) {
        DeployedApplication deployedApp = DeltaSpecifications.createDeployedApplication((Version)dp, (Environment)env2);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApp);
        DeploymentOperationCalculator.calculate((DeltaSpecificationBuilder)builder, (Set)JavaConversions$.MODULE$.mutableSetAsJavaSet(Set$.MODULE$.empty()), (Set)JavaConversions$.MODULE$.mutableSetAsJavaSet(set));
        return builder.build();
    }

    public static void importPackage(Generator $this, String id) {
        File dir = TestServiceHolder.getImporterService().getImportablePackageDirectory();
        String string = TestServiceHolder.getImporterService().importPackage((ImportSource)new FileSource(new File(dir, id).getPath(), false));
    }

    public static Generator.TaskDsl task2dsl(Generator $this, ArchivedTask task) {
        return new Generator.TaskDsl($this, task);
    }

    public static void $init$(Generator $this) {
        $this.com$xebialabs$deployit$rest$test$api$Generator$_setter_$tester_$eq(DeployitTester.build());
    }
}

