package com.xebialabs.deployit.plugin.sql.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.plugin.sql.support.VelocityUtils;
import org.apache.commons.lang.StringUtils;

@SuppressWarnings("serial")
@ConfigurationItem(description = "SQL Oracle database instance")
public class MSSQLDatabase extends Database {

	static final String SQLCMD_EXE = "sqlcmd.exe";

	@ConfigurationItemProperty(required = true, description = "–S SERVER\\instance")
	private String server;

	@ConfigurationItemProperty(required = false, label = "sqlcmd Path", description = "sqlcmd.exe Path, ex c:\\path\\to")
	private String sqlcmdPath;


	public String getSqlcmdPath() {
		return sqlcmdPath;
	}

	public void setSqlcmdPath(String sqlcmdPath) {
		this.sqlcmdPath = sqlcmdPath;
	}


	public String getServer() {
		return server;
	}

	public void setServer(String server) {
		this.server = server;
	}

	//sqlcmd –S SERVER\instance –U ${username} –P ${password} –d ${database} –i
	//SQLCMD.EXE -S %BD_SERVEUR_APPLI% -d %BD_BASE_APPLI% -i %SQL% -o %LOGSQL%
	@Override
	public String getCommand() {

		if (StringUtils.isNotBlank(super.getCommand())) {
			return super.getCommand();
		}

		final String os = getHost().getOperatingSystemFamily().toString().toLowerCase();
		return VelocityUtils.evaluateTemplate(this, "com/xebialabs/deployit/plugin/sql/mssql/" + os + "_template.vm");
	}


}
