package com.xebialabs.deployit.cli.util;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import static com.google.common.base.Preconditions.checkNotNull;

import static com.google.common.base.Preconditions.checkArgument;

import static com.google.common.base.Preconditions.checkState;

public class PasswordEncrypter {

    private static final Base64Coder BASE_64_CODER = new Base64Coder();

    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference<>();

    public static final SecretKey PASSWORD_ENCRYPTION_KEY =  new SecretKeySpec(new byte[]{
        (byte) 0xe3, (byte) 0xea, 0x16, (byte) 0xaf, (byte) 0x94, 0x5f, 0x5b, 0x17,
        0x2e, (byte) 0xe6, 0x31, (byte) 0xd3, (byte) 0xc0, 0x70, 0x27, (byte) 0xd6
    }, "AES");


    private PasswordEncrypter() {
    }

    public static void init() {
        instance.set(new PasswordEncrypter());
    }

    public static PasswordEncrypter getInstance() {
        checkState(instance.get() != null, "PasswordEncrypter not yet set, please construct one.");
        return instance.get();
    }

    public boolean isEncoded(String text) {
        try {
            BASE_64_CODER.decode(text.getBytes());
            return true;
        } catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEncrypted(String text) {
        if (isEncoded(text)) {
            byte[] decode = BASE_64_CODER.decode(text.getBytes());
            try {
                Cipher cipher = getCipher(Cipher.DECRYPT_MODE);
                cipher.doFinal(decode);

                return true;
            } catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    private String encrypt(String plaintext) {
        checkNotNull(plaintext, "The password is null");
        checkArgument(!plaintext.startsWith(BASE_64_CODER.identifier()), "The password contains the illegal sequence " + BASE_64_CODER.identifier());

        try {
            Cipher aes = getCipher(Cipher.ENCRYPT_MODE);
            return new String(BASE_64_CODER.encode(aes.doFinal(plaintext.getBytes())));
        } catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encrypt the password.");
        }
    }

    public String ensureEncrypted(String text) {
        if (isEncrypted(text)) {
            return text;
        } else {
            return encrypt(text);
        }
    }

    private String decrypt(String encryptedText) {
        checkArgument(encryptedText != null, "The password is null");
        checkArgument(encryptedText.startsWith(BASE_64_CODER.identifier()), "The password should be Base64 encoded");

        try {
            Cipher aes = getCipher(Cipher.DECRYPT_MODE);
            return new String(aes.doFinal(BASE_64_CODER.decode(encryptedText.getBytes())));
        } catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not decrypt the password.");
        }
    }

    public String ensureDecrypted(String text) {
        if (isEncrypted(text)) {
            return decrypt(text);
        } else {
            return text;
        }
    }

    private Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance(PASSWORD_ENCRYPTION_KEY.getAlgorithm());
        aes.init(mode, PASSWORD_ENCRYPTION_KEY);
        return aes;
    }

}
