package com.xebialabs.deployit.cli.api.legacy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.engine.api.execution.TaskState;

/**
 * Translates the new {@link TaskState} object to the legacy Deployit 3.7 {@code TaskInfo} API.
 *
 * @ deprecated Use {@link TaskState}.
 */
//@Deprecated
public class TaskInfo {
    private final TaskState task;

    public TaskInfo(TaskState task) {
        this.task = task;
    }

    public static List<TaskInfo> asList(List<TaskState> tasks) {
        List<TaskInfo> result = new ArrayList<>(tasks.size());
        for (TaskState task : tasks) {
            result.add(new TaskInfo(task));
        }
        return result;
    }

    public TaskState getTaskState() {
        return task;
    }

    public String getId() {
        return task.getId();
    }

    public String getLabel() {
        return task.getDescription();
    }

    public String getState() {
        return task.getState().toString();
    }

    public Calendar getScheduledDate() {
        return task.getScheduledDate() != null ? task.getScheduledDate().toGregorianCalendar() : null;
    }

    public Calendar getStartDate() {
        return task.getStartDate() != null ? task.getStartDate().toGregorianCalendar() : null;
    }

    public Calendar getCompletionDate() {
        return task.getCompletionDate() != null ? task.getCompletionDate().toGregorianCalendar() : null;
    }

    public int getNrOfSteps() {
        return task.getNrSteps();
    }

    public int getCurrentStepNr() {
        return task.getCurrentStepNr();
    }

    public List<String> getCurrentStepNrs() {
        return Lists.transform(task.getCurrentStepNrs(), Functions.toStringFunction());
    }

    public String getUser() {
        return task.getOwner();
    }

    public String getApplication() {
        return task.getMetadata().get("application");
    }

    public String getVersion() {
        return task.getMetadata().get("version");
    }

    public String getEnvironment() {
        return task.getMetadata().get("environment");
    }

    public int getFailureCount() {
        return task.getFailureCount();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE)
            .append("id", getId())
            .append("label", getLabel())
            .append("state", getState())
            .append("scheduledDate", getScheduledDate())
            .append("startDate", getStartDate())
            .append("completionDate", getCompletionDate())
            .append("nrOfSteps", getNrOfSteps())
            .append("currentStepNr", getCurrentStepNr())
            .append("currentStepNrs", getCurrentStepNrs())
            .append("user", getUser())
            .append("application", getApplication())
            .append("version", getVersion())
            .append("environment", getEnvironment())
            .append("failureCount", getFailureCount())
            .toString();
    }
}
