package com.xebialabs.deployit.cli.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import static java.lang.String.format;

public class FileUtils {
    private FileUtils() {}

    public static String readFile(String file) throws IOException {
        try {
            return String.join("\n", Files.readAllLines(Paths.get(file)));
        } catch (IOException exc) {
            throw new IOException(format("The file path %s could not be found.", file));
        }
    }

    public static String readFile(File file) throws IOException {
        try {
            return String.join("\n", Files.readAllLines(file.toPath()));
        } catch (IOException exc) {
            throw new IOException(format("The file path %s could not be found.", file));
        }
    }

    public static List<File> readFiles(List<String> fileNames, String path) throws IOException {
        File folder = new File(path);
        List<File> files = new ArrayList<>();
        for (String file : fileNames) {
            File e = getFile(folder, file);
            files.add(e);
        }
        return files;
    }

    private static File getFile(File folder, String file) throws IOException {
        Path filePath = Paths.get(file);
        if (filePath.isAbsolute()) {
            return checkNonExistingPath(filePath.toFile());
        }
        Path pathIncludingFolder = Paths.get(folder.getPath(), file);
        return checkNonExistingPath(pathIncludingFolder.toFile());
    }

    private static File checkNonExistingPath(File file) throws IOException {
        if (file.exists()) return file;
        else {
            throw new IOException(format("%s could not be found in %s", file.getName(), file.getParent()));
        }
    }

    public static void writeFile(String content, File file) throws IOException {
        Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8));
    }
}
