/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.xebialabs.deployit.client.Authentication;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.client.Container;
import com.xebialabs.deployit.client.Deployed;
import com.xebialabs.deployit.client.DeployitClient;
import com.xebialabs.deployit.client.DeployitProxies;
import com.xebialabs.deployit.client.DeploymentClient;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.client.DeploymentOptions;
import com.xebialabs.deployit.client.Descriptors;
import com.xebialabs.deployit.client.RepositoryClient;
import com.xebialabs.deployit.client.ResponseExtractor;
import com.xebialabs.deployit.client.logger.Slf4jDeploymentListener;
import com.xebialabs.deployit.client.ssl.SelfSignedCertificateAcceptingSocketFactory;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;

public class DeployitCli {
    private final DeploymentListener listener;
    private ConnectionOptions options;
    private final Authentication authentication;
    private final DeployitProxies proxies;
    private final DeploymentClient deploymentClient;
    private final DeployitClient deployitClient;
    private final RepositoryClient repositoryClient;
    private AtomicReference<Descriptors> descriptors = new AtomicReference();

    public DeployitCli(ConnectionOptions options) {
        this(options, null);
    }

    public DeployitCli(ConnectionOptions options, DeploymentListener listener) {
        this.listener = listener != null ? listener : new Slf4jDeploymentListener(DeployitCli.class);
        this.options = options;
        this.authentication = new Authentication(options);
        try {
            this.setupSecureCommunications();
            this.attemptToConnectToServer();
            this.proxies = new DeployitProxies(options, this.authentication);
            this.deploymentClient = new DeploymentClient(this.proxies);
            this.deployitClient = new DeployitClient(this.proxies);
            this.repositoryClient = new RepositoryClient(this.proxies);
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization failed", e);
        }
    }

    public void resetCredentials(String username, String password) {
        if (this.authentication.getUserName().equals(username) && this.authentication.password.equals(password)) {
            return;
        }
        this.authentication.logout();
        this.authentication.loginAs(username, password);
    }

    private void setupSecureCommunications() {
        if (this.options.isSecured()) {
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)new SelfSignedCertificateAcceptingSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        }
    }

    private void attemptToConnectToServer() {
        String urlToConnectTo = this.options.getUrl();
        this.getListener().info("Connecting to the Deployit server at " + urlToConnectTo + "...");
        try {
            int responseCode = this.authentication.getHttpClient().executeMethod((HttpMethod)new GetMethod(urlToConnectTo + "/server/info"));
            if (responseCode != 200) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
            }
            this.getListener().info("Succesfully connected.");
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
        }
    }

    public RepositoryObject create(Container ci) {
        String id = ci.getId();
        try {
            return this.get(id);
        }
        catch (Exception e) {
            this.getListener().debug(String.format("%s does not exist, create it", id));
            ConfigurationItemDto configurationItem = new ConfigurationItemDto(id, ci.getType());
            configurationItem.setValues((Map)Maps.newHashMap(ci.getProperties()));
            Response response = this.getProxies().getRepository().create(configurationItem.getId(), configurationItem);
            return this.checkForValidations(response);
        }
    }

    public void delete(String id) {
        try {
            this.getListener().debug("Delete " + id);
            this.repositoryClient.delete(id);
        }
        catch (Exception e) {
            this.getListener().debug(String.format("delete fails %s", id));
        }
    }

    public List<String> search(String type) {
        try {
            this.getListener().debug("search " + type);
            return this.repositoryClient.search(type, null);
        }
        catch (Exception e) {
            this.getListener().debug(String.format("search fails for %s %s", type, e.getMessage()));
            return Collections.emptyList();
        }
    }

    public ServerInfo info() {
        Response response = this.getProxies().getServer().getInfo();
        return (ServerInfo)new ResponseExtractor(response).getEntity();
    }

    public RepositoryObject get(String ciId) {
        Response response = this.getProxies().getRepository().read(ciId);
        return this.checkForValidations(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptors getDescriptors() {
        if (this.descriptors.get() == null) {
            DeployitCli deployitCli = this;
            synchronized (deployitCli) {
                Response response = this.getProxies().getDescriptor().list();
                ResponseExtractor responseExtractor = new ResponseExtractor(response);
                ConfigurationItemDescriptorList entity = (ConfigurationItemDescriptorList)responseExtractor.getEntity();
                this.descriptors.set(new Descriptors(entity.getDescriptors()));
            }
        }
        return this.descriptors.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryObject importPackage(String darFileLocation, DeploymentListener listener) {
        this.getListener().setActionListener(listener);
        try {
            RepositoryObject repositoryObject = this.deployitClient.importPackage(darFileLocation);
            return repositoryObject;
        }
        finally {
            this.getListener().setActionListener(null);
        }
    }

    public String deploy(String source, String target, List<? extends Deployed> configuredDeployeds, DeploymentOptions deploymentOptions, DeploymentListener listener) {
        Deployment deployment;
        this.getListener().setActionListener(listener);
        this.getListener().debug(deploymentOptions.toString());
        String previouslyDeployedApplicationId = null;
        boolean initialDeployment = this.isInitialDeployment(source, target);
        if (initialDeployment) {
            this.getListener().info("initial Deployment");
            deployment = this.deploymentClient.prepareInitial(source, target);
            if (!deploymentOptions.isExplicitMappings()) {
                this.getListener().debug(" generateAllDeployeds");
                deployment = this.deploymentClient.generateAllDeployeds(deployment);
            }
        } else {
            this.getListener().info("upgrade Deployment");
            String deployedApplicationId = this.getDeployedApplicationId(source, target);
            previouslyDeployedApplicationId = this.getPreviousDeployedPackage(deployedApplicationId);
            deployment = this.deploymentClient.prepareUpgrade(source, deployedApplicationId);
            if (!deploymentOptions.isExplicitMappings() && deploymentOptions.isGenerateDeployedOnUpgrade()) {
                this.getListener().debug(" generateAllDeployeds");
                deployment = this.deploymentClient.generateAllDeployeds(deployment);
            }
        }
        if (deploymentOptions.isExplicitMappings()) {
            this.getListener().debug("use explicits deployeds");
            for (Deployed deployed : configuredDeployeds) {
                Preconditions.checkNotNull((Object)deployed.getId(), (Object)"id is mandatory in the explicit deployed mode");
                String type = deployed.getType();
                Preconditions.checkNotNull((Object)type, (Object)"type is mandatory in the explicit deployed mode");
                final String deployableId = deployed.getDeployable(source);
                final String containerId = deployed.getContainer();
                boolean exist = Iterables.any((Iterable)deployment.getDeployeds(), (Predicate)new Predicate<ConfigurationItemDto>(){

                    public boolean apply(ConfigurationItemDto input) {
                        return input.getValues().get("deployable").equals(deployableId) && input.getValues().get("container").equals(containerId);
                    }
                });
                if (exist) {
                    this.getListener().debug(String.format(" deployed  %s %s %s already exists", deployableId, containerId, type));
                    continue;
                }
                this.getListener().debug(String.format(" generateSingleDeployed %s %s %s", deployableId, containerId, type));
                deployment = this.deploymentClient.generateSingleDeployed(deployableId, containerId, type, deployment);
            }
        }
        if (configuredDeployeds != null) {
            this.getListener().debug("update the generated deployeds with the configured deployeds");
            List deployeds = deployment.getDeployeds();
            for (ConfigurationItemDto configurationItem : deployeds) {
                this.getListener().debug(" check " + configurationItem);
                final String id = configurationItem.getId();
                UnmodifiableIterator deployedIterator = Iterators.filter(configuredDeployeds.iterator(), (Predicate)new Predicate<Deployed>(){

                    public boolean apply(Deployed input) {
                        return input.getId().equals(id);
                    }
                });
                if (deployedIterator.hasNext()) {
                    this.updateConfigurationItemValues(configurationItem, (Deployed)deployedIterator.next());
                    continue;
                }
                this.getListener().debug(" no configured deployed found with id " + configurationItem.getId());
            }
        }
        this.getListener().debug(" dump Deployeds");
        for (ConfigurationItemDto configurationItemDto : deployment.getDeployeds()) {
            this.getListener().debug(" - " + configurationItemDto);
        }
        try {
            this.getListener().debug("validate");
            deployment = this.deploymentClient.validate(deployment);
        }
        catch (RuntimeException e) {
            this.getListener().error(" RuntimeException: " + e.getMessage());
            if (deploymentOptions.isFailIfNoStepsAreGenerated() || !e.getMessage().contains("The task did not deliver any steps")) {
                throw e;
            }
            return null;
        }
        int validationMessagesFound = 0;
        for (ConfigurationItemDto configurationItem : deployment.getDeployeds()) {
            for (Message msg : configurationItem.getValidations()) {
                this.getListener().error(String.format("Validation error found on '%s' on field '%s': %s, %s", configurationItem.getId(), msg.getField(), msg.getMessage(), configurationItem));
                this.getListener().error(String.format(" %s", configurationItem));
                ++validationMessagesFound;
            }
        }
        if (validationMessagesFound > 0) {
            throw new IllegalStateException(String.format("Validation errors (%d) have been found", validationMessagesFound));
        }
        this.getListener().debug("deploy");
        this.executeTask(this.deploymentClient.deploy(deployment).getTaskId(), deploymentOptions);
        if (this.shouldDeletePreviousVersion(deploymentOptions, previouslyDeployedApplicationId)) {
            this.getListener().info("Delete previously deployed dar " + previouslyDeployedApplicationId);
            this.delete(previouslyDeployedApplicationId);
        }
        return previouslyDeployedApplicationId;
    }

    public void undeployAndWait(String source) {
        this.getListener().info("   undeployAndWait " + source);
        String taskId = this.deploymentClient.undeploy(source).getTaskId();
        this.executeTask(taskId, new DeploymentOptions());
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            throw new IllegalStateException(String.format("Configuration item contained validation errors: {%s}", ci.getValidations()));
        }
        return ci;
    }

    private void updateConfigurationItemValues(ConfigurationItemDto configurationItem, Deployed configuredDeployed) {
        this.getListener().debug(String.format(" update values of %s with %s", configuredDeployed.getId(), configuredDeployed.getValues()));
        configurationItem.getValues().putAll(configuredDeployed.getValues());
        if (!configuredDeployed.getPlaceholders().isEmpty()) {
            if (!configurationItem.getValues().containsKey("placeholders")) {
                configurationItem.getValues().put("placeholders", new HashMap());
            }
            Map placeholders = (Map)configurationItem.getValues().get("placeholders");
            placeholders.putAll(configuredDeployed.getPlaceholders());
        }
        this.getListener().debug(configurationItem.getValues().toString());
    }

    private boolean executeTask(String taskId, DeploymentOptions deploymentOptions) {
        if (deploymentOptions.isSkipMode()) {
            this.getListener().info("skip mode, skip all the steps");
            this.getDeployitClient().skipSteps(taskId, this.range(this.getDeployitClient().retrieveTaskInfo(taskId).getNrOfSteps() + 1));
        }
        this.checkTaskState(taskId);
        if (deploymentOptions.isTestMode()) {
            this.getListener().info("test mode, cancel task " + taskId);
            this.getDeployitClient().cancelTask(taskId);
            return false;
        }
        try {
            this.getListener().info("Start deployment task " + taskId);
            this.getDeployitClient().startTaskAndWait(taskId);
            this.checkTaskState(taskId);
            return true;
        }
        catch (RuntimeException e) {
            if (taskId != null) {
                this.getListener().error(String.format("Error when executing task %s: %s", taskId, e.getMessage()));
                if (deploymentOptions.isCancelTaskOnError()) {
                    this.getDeployitClient().cancelTask(taskId);
                }
            }
            throw e;
        }
    }

    private boolean isInitialDeployment(String source, String target) {
        String deployedApplicationId = this.getDeployedApplicationId(source, target);
        this.getListener().debug("  deployedApplicationId " + deployedApplicationId);
        try {
            this.get(deployedApplicationId);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private String getDeployedApplicationId(String source, String target) {
        return Joiner.on((String)"/").join((Object)target, ImmutableList.copyOf((Iterable)Splitter.on((String)"/").split((CharSequence)source)).get(1), new Object[0]);
    }

    private String getPreviousDeployedPackage(String target) {
        RepositoryObject dp = this.repositoryClient.read(target);
        Map values = dp.getValues();
        Object source = values.get("version");
        return source == null ? null : source.toString();
    }

    private void checkTaskState(String taskId) {
        TaskInfo taskInfo = this.getDeployitClient().retrieveTaskInfo(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.getListener().info(String.format("%s Label      %s", taskId, taskInfo.getLabel()));
        this.getListener().info(String.format("%s State      %s %d/%d", taskId, taskInfo.getState(), taskInfo.getCurrentStepNr(), taskInfo.getNrOfSteps()));
        if (taskInfo.getStartDate() != null) {
            GregorianCalendar startDate = (GregorianCalendar)taskInfo.getStartDate();
            this.getListener().info(String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        }
        if (taskInfo.getCompletionDate() != null) {
            GregorianCalendar completionDate = (GregorianCalendar)taskInfo.getCompletionDate();
            this.getListener().info(String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= taskInfo.getNrOfSteps(); ++i) {
            Response stepInfoResponse = this.getProxies().getTaskRegistry().getStepInfo(taskId, i, null);
            StepInfo stepInfo = (StepInfo)new ResponseExtractor(stepInfoResponse).getEntity();
            String description = stepInfo.getDescription();
            String log = stepInfo.getLog();
            String stepInfoMessage = StringUtils.isEmpty((String)log) || description.equals(log) ? String.format("%s step #%d %s\t%s", taskId, i, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, i, stepInfo.getState(), description, log);
            this.getListener().info(stepInfoMessage);
            if (!"FAILED".endsWith(stepInfo.getState())) continue;
            sb.append(stepInfoMessage);
        }
        if ("STOPPED".equals(taskInfo.getState())) {
            throw new IllegalStateException(String.format("Errors when executing task %s: %s", taskId, sb));
        }
    }

    private Integer[] range(int end) {
        Integer[] result = new Integer[end - 1];
        for (int i = 1; i < end; ++i) {
            result[i - 1] = i;
        }
        return result;
    }

    private boolean shouldDeletePreviousVersion(DeploymentOptions deploymentOptions, String previousPackageId) {
        if (deploymentOptions.isTestMode()) {
            return false;
        }
        return deploymentOptions.isDeletePreviouslyDeployedArtifact() && Strings.emptyToNull((String)previousPackageId) != null;
    }

    private DeployitClient getDeployitClient() {
        return this.deployitClient;
    }

    private DeploymentClient getDeploymentClient() {
        return this.deploymentClient;
    }

    private DeployitProxies getProxies() {
        return this.proxies;
    }

    public DeploymentListener getListener() {
        return this.listener;
    }
}

