/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.client.Container;
import com.xebialabs.deployit.client.Deployed;
import com.xebialabs.deployit.client.DeployitClient;
import com.xebialabs.deployit.client.DeploymentClient;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.client.DeploymentOptions;
import com.xebialabs.deployit.client.Descriptors;
import com.xebialabs.deployit.client.logger.Slf4jDeploymentListener;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public class DeployitCli {
    private final DeploymentListener listener;
    private ConnectionOptions options;
    private DeployitCommunicator communicator;
    private final DeploymentClient deploymentClient;
    private final DeployitClient deployitClient;
    private AtomicReference<Descriptors> descriptors = new AtomicReference();

    public DeployitCli(ConnectionOptions options) {
        this(options, null);
    }

    public DeployitCli(ConnectionOptions options, DeploymentListener listener) {
        this(options, listener, BooterConfig.builder().withProtocol(options.isSecured() ? BooterConfig.Protocol.HTTPS : BooterConfig.Protocol.HTTP).withCredentials(options.getUsername(), options.getPassword()).withHost(options.getHost()).withPort(options.getPort()).withContext(options.getContext()).build());
    }

    public DeployitCli(ConnectionOptions options, DeploymentListener listener, BooterConfig booterConfig) {
        this.listener = listener != null ? listener : new Slf4jDeploymentListener(DeployitCli.class);
        this.options = options;
        try {
            this.connect(booterConfig);
            this.deploymentClient = new DeploymentClient(this.communicator.getProxies().getDeploymentService());
            this.deployitClient = new DeployitClient(this.listener, this.communicator.getProxies());
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization failed", e);
        }
    }

    private void connect(BooterConfig config) {
        this.getListener().info("Connecting to the Deployit server at " + this.options.getHost() + "...");
        this.communicator = RemoteBooter.boot((BooterConfig)config);
    }

    public ConfigurationItem create(Container ci) {
        String id = ci.getId();
        try {
            return this.get(id);
        }
        catch (Exception e) {
            this.getListener().debug(String.format("%s does not exist, create it", id));
            BaseConfigurationItem baseConfigurationItem = new BaseConfigurationItem();
            baseConfigurationItem.setId(id);
            baseConfigurationItem.setType(Type.valueOf((String)ci.getType()));
            for (Map.Entry<String, Object> entry : ci.getProperties().entrySet()) {
                baseConfigurationItem.setProperty(entry.getKey(), entry.getValue());
            }
            return this.communicator.getProxies().getRepositoryService().create(id, (ConfigurationItem)baseConfigurationItem);
        }
    }

    public void delete(String id) {
        try {
            this.getListener().debug("Delete " + id);
            this.communicator.getProxies().getRepositoryService().delete(id);
        }
        catch (Exception e) {
            this.getListener().debug(String.format("delete fails %s", id));
        }
    }

    public List<String> search(String type) {
        this.getListener().debug("search " + type);
        try {
            List result = this.communicator.getProxies().getRepositoryService().query(Type.valueOf((String)type), null, null, null, null, 0L, -1L);
            return Lists.transform((List)result, (Function)new Function<ConfigurationItemId, String>(){

                public String apply(ConfigurationItemId input) {
                    return input.getId();
                }
            });
        }
        catch (Exception e) {
            this.getListener().debug(String.format("search fails for %s %s", type, e.getMessage()));
            return Collections.emptyList();
        }
    }

    public ServerInfo info() {
        return this.communicator.getProxies().getServerService().getInfo();
    }

    public ConfigurationItem get(String ciId) {
        return this.communicator.getProxies().getRepositoryService().read(ciId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptors getDescriptors() {
        if (this.descriptors.get() == null) {
            DeployitCli deployitCli = this;
            synchronized (deployitCli) {
                List retrievedDescriptors = this.communicator.getProxies().getMetadataService().listDescriptors();
                this.descriptors.set(new Descriptors(retrievedDescriptors));
            }
        }
        return this.descriptors.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String deploy(String source, String target, List<? extends Deployed> configuredDeployeds, DeploymentOptions deploymentOptions, DeploymentListener listener) {
        void var10_16;
        String orchestrator;
        Deployment deployment;
        this.getListener().setActionListener(listener);
        this.getListener().debug(deploymentOptions.toString());
        String previouslyDeployedApplicationId = null;
        boolean initialDeployment = this.isInitialDeployment(source, target);
        if (initialDeployment) {
            this.getListener().info("initial Deployment");
            deployment = this.deploymentClient.prepareInitial(source, target);
            if (!deploymentOptions.isExplicitMappings()) {
                this.getListener().debug(" generateAllDeployeds");
                deployment = this.deploymentClient.generateAllDeployeds(deployment);
            }
        } else {
            this.getListener().info("upgrade Deployment");
            String deployedApplicationId = this.getDeployedApplicationId(source, target);
            previouslyDeployedApplicationId = this.getPreviousDeployedPackage(deployedApplicationId);
            deployment = this.deploymentClient.prepareUpgrade(source, deployedApplicationId);
            if (!deploymentOptions.isExplicitMappings() && deploymentOptions.isGenerateDeployedOnUpgrade()) {
                this.getListener().debug(" generateAllDeployeds");
                deployment = this.deploymentClient.generateAllDeployeds(deployment);
            }
        }
        if (deploymentOptions.isExplicitMappings()) {
            this.getListener().debug("use explicits deployeds");
            for (Deployed deployed : configuredDeployeds) {
                Preconditions.checkNotNull((Object)deployed.getId(), (Object)"id is mandatory in the explicit deployed mode");
                String type = deployed.getType();
                Preconditions.checkNotNull((Object)type, (Object)"type is mandatory in the explicit deployed mode");
                final String deployableId = deployed.getDeployable(source);
                final String containerId = deployed.getContainer();
                boolean exist = Iterables.any((Iterable)deployment.getDeployeds(), (Predicate)new Predicate<ConfigurationItem>(){

                    public boolean apply(ConfigurationItem input) {
                        return input.getProperty("deployable").equals(deployableId) && input.getProperty("container").equals(containerId);
                    }
                });
                if (exist) {
                    this.getListener().debug(String.format(" deployed  %s %s %s already exists", deployableId, containerId, type));
                    continue;
                }
                this.getListener().debug(String.format(" generateSingleDeployed %s %s %s", deployableId, containerId, type));
                deployment = this.deploymentClient.generateSingleDeployed(deployableId, containerId, type, deployment);
            }
        }
        if (configuredDeployeds != null) {
            this.getListener().debug("update the generated deployeds with the configured deployeds");
            List deployeds = deployment.getDeployeds();
            for (ConfigurationItem configurationItem : deployeds) {
                this.getListener().debug(" check " + configurationItem);
                final String id = configurationItem.getId();
                UnmodifiableIterator deployedIterator = Iterators.filter(configuredDeployeds.iterator(), (Predicate)new Predicate<Deployed>(){

                    public boolean apply(Deployed input) {
                        return input.getId().equals(id);
                    }
                });
                if (deployedIterator.hasNext()) {
                    this.updateConfigurationItemValues(configurationItem, (Deployed)deployedIterator.next());
                    continue;
                }
                this.getListener().debug(" no configured deployed found with id " + configurationItem.getId());
            }
        }
        if (!Strings.isNullOrEmpty((String)(orchestrator = deploymentOptions.getOrchestrator()))) {
            this.getListener().debug("set the orchestrator " + orchestrator);
            deployment.getDeployedApplication().setProperty("orchestrator", (Object)orchestrator);
        }
        this.getListener().debug(" dump Deployeds");
        for (ConfigurationItem itemDto : deployment.getDeployeds()) {
            this.getListener().debug(" - " + itemDto);
        }
        try {
            this.getListener().debug("validate");
            deployment = this.deploymentClient.validate(deployment);
        }
        catch (RuntimeException runtimeException) {
            this.getListener().error(" RuntimeException: " + runtimeException.getMessage());
            if (deploymentOptions.isFailIfNoStepsAreGenerated() || !runtimeException.getMessage().contains("The task did not deliver any steps")) {
                throw runtimeException;
            }
            return null;
        }
        boolean bl = false;
        for (ConfigurationItem configurationItem : deployment.getDeployeds()) {
            if (!(configurationItem instanceof ValidatedConfigurationItem)) continue;
            for (ValidationMessage msg : ((ValidatedConfigurationItem)configurationItem).getValidations()) {
                this.getListener().error(String.format("Validation error found on '%s' on field '%s': %s, %s", configurationItem.getId(), msg.getCiId(), msg.getMessage(), configurationItem));
                this.getListener().error(String.format(" %s", configurationItem));
                ++var10_16;
            }
        }
        if (var10_16 > 0) {
            throw new IllegalStateException(String.format("Validation errors (%d) have been found", (int)var10_16));
        }
        this.getListener().debug("deploy");
        String taskId = this.deploymentClient.deploy(deployment);
        try {
            this.executeTask(taskId, deploymentOptions);
        }
        catch (RuntimeException e) {
            try {
                if (deploymentOptions.isRollbackOnError()) {
                    this.getListener().error("Deployment failed, performing a rollback");
                    this.executeTask(this.rollback(taskId, this.getListener()), deploymentOptions);
                }
            }
            finally {
                throw e;
            }
        }
        if (this.shouldDeletePreviousVersion(deploymentOptions, previouslyDeployedApplicationId)) {
            this.getListener().info("Delete previously deployed dar " + previouslyDeployedApplicationId);
            this.delete(previouslyDeployedApplicationId);
        }
        return previouslyDeployedApplicationId;
    }

    public String rollback(String taskid, DeploymentListener listener) {
        return this.deploymentClient.rollback(taskid);
    }

    public void undeployAndWait(String source) {
        this.getListener().info("   undeployAndWait " + source);
        String taskId = this.deploymentClient.undeploy(source);
        this.executeTask(taskId, new DeploymentOptions());
    }

    private void updateConfigurationItemValues(ConfigurationItem configurationItem, Deployed configuredDeployed) {
        this.getListener().debug(String.format(" update values of %s with %s", configuredDeployed.getId(), configuredDeployed.getValues()));
        for (Map.Entry<String, Object> e : configuredDeployed.getValues().entrySet()) {
            configurationItem.setProperty(e.getKey(), e.getValue());
        }
        if (!configuredDeployed.getPlaceholders().isEmpty()) {
            if (!configurationItem.hasProperty("placeholders")) {
                configurationItem.setProperty("placeholders", new HashMap());
            }
            Map placeholders = (Map)configurationItem.getProperty("placeholders");
            placeholders.putAll(configuredDeployed.getPlaceholders());
        }
        this.getListener().debug(configurationItem.toString());
    }

    private boolean executeTask(String taskId, DeploymentOptions deploymentOptions) {
        if (deploymentOptions.isSkipMode()) {
            this.getListener().info("skip mode, skip all the steps");
            this.getDeployitClient().skipSteps(taskId, this.range(this.getDeployitClient().retrieveTaskInfo(taskId).getNrSteps() + 1));
        }
        this.checkTaskState(taskId);
        if (deploymentOptions.isTestMode()) {
            this.getListener().info("test mode, cancel task " + taskId);
            this.getDeployitClient().cancelTask(taskId);
            return false;
        }
        try {
            this.getListener().info("Start deployment task " + taskId);
            this.getDeployitClient().startTaskAndWait(taskId);
            this.checkTaskState(taskId);
            this.communicator.getProxies().getTaskService().archive(taskId);
            return true;
        }
        catch (RuntimeException e) {
            if (taskId != null) {
                this.getListener().error(String.format("Error when executing task %s: %s", taskId, e.getMessage()));
                if (deploymentOptions.isCancelTaskOnError()) {
                    this.getDeployitClient().cancelTask(taskId);
                }
            }
            throw e;
        }
    }

    private boolean isInitialDeployment(String source, String target) {
        String deployedApplicationId = this.getDeployedApplicationId(source, target);
        this.getListener().debug("  deployedApplicationId " + deployedApplicationId);
        try {
            this.get(deployedApplicationId);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private String getDeployedApplicationId(String source, String target) {
        ArrayList splitSource = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)source));
        String appName = (String)splitSource.get(splitSource.size() - 2);
        return Joiner.on((String)"/").join((Object)target, (Object)appName, new Object[0]);
    }

    private String getPreviousDeployedPackage(String target) {
        ConfigurationItem dp = this.communicator.getProxies().getRepositoryService().read(target);
        Object source = dp.getProperty("version");
        return source == null ? null : source.toString();
    }

    private void checkTaskState(String taskId) {
        TaskState taskState = this.communicator.getProxies().getTaskService().getTask(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.getListener().info(String.format("%s Description\t%s", taskId, taskState.getDescription()));
        this.getListener().info(String.format("%s State      \t%s %d/%d", taskId, taskState.getState(), taskState.getCurrentStepNr(), taskState.getNrSteps()));
        if (taskState.getStartDate() != null) {
            GregorianCalendar startDate = taskState.getStartDate().toGregorianCalendar();
            this.getListener().info(String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        }
        if (taskState.getCompletionDate() != null) {
            GregorianCalendar completionDate = taskState.getCompletionDate().toGregorianCalendar();
            this.getListener().info(String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= taskState.getNrSteps(); ++i) {
            StepState stepInfo = this.communicator.getProxies().getTaskService().getStep(taskId, i, null);
            String description = stepInfo.getDescription();
            String log = stepInfo.getLog();
            String stepInfoMessage = StringUtils.isEmpty((String)log) || description.equals(log) ? String.format("%s step #%d %s\t%s", taskId, i, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, i, stepInfo.getState(), description, log);
            this.getListener().info(stepInfoMessage);
            if (!StepExecutionState.FAILED.equals((Object)stepInfo.getState())) continue;
            sb.append(stepInfoMessage);
        }
        if (TaskExecutionState.STOPPED.equals((Object)taskState.getState())) {
            throw new IllegalStateException(String.format("Errors when executing task %s: %s", taskId, sb));
        }
    }

    private Integer[] range(int end) {
        Integer[] result = new Integer[end - 1];
        for (int i = 1; i < end; ++i) {
            result[i - 1] = i;
        }
        return result;
    }

    private boolean shouldDeletePreviousVersion(DeploymentOptions deploymentOptions, String previousPackageId) {
        if (deploymentOptions.isTestMode()) {
            return false;
        }
        return deploymentOptions.isDeletePreviouslyDeployedArtifact() && Strings.emptyToNull((String)previousPackageId) != null;
    }

    private DeployitClient getDeployitClient() {
        return this.deployitClient;
    }

    public DeploymentListener getListener() {
        return this.listener;
    }

    public DeployitCommunicator getCommunicator() {
        return this.communicator;
    }
}

