package com.xebialabs.deployit.client;

import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;

public class DeploymentClient {

	private final DeploymentService deploymentProxy;

	public DeploymentClient(DeploymentService deploymentProxy) {
		this.deploymentProxy = deploymentProxy;
	}

	public Deployment prepareInitial(String version, String environment) {
		return deploymentProxy.prepareInitial(version, environment);
	}

	public Deployment prepareUpgrade(String version, String deployedApplication) {
		return deploymentProxy.prepareUpdate(version, deployedApplication);
	}

    /**
     * @deprecated Replaced by prepareAutoDeployeds
     */
    @Deprecated
	public Deployment generateAllDeployeds(Deployment deployment) {
		return deploymentProxy.generateAllDeployeds(deployment);
	}

    public Deployment prepareAutoDeployeds(Deployment deployment) {
        return deploymentProxy.prepareAutoDeployeds(deployment);
    }

	public Deployment generateSingleDeployed(String deployable, String container, String type, Deployment deployment) {
		return deploymentProxy.generateSingleDeployed(deployable, container, Type.valueOf(type), deployment);
	}

	public Deployment validate(Deployment deployment) {
		return deploymentProxy.validate(deployment);
	}

	public String deploy(Deployment deployment) {
		return deploymentProxy.createTask(deployment);
	}

	public String undeploy(String deployedApplication) {
		return deploymentProxy.createTask(
				deploymentProxy.prepareUndeploy(deployedApplication)
		);
	}
	
	public String rollback(String taskid) {
		return deploymentProxy.rollback(taskid);
	}
}
