/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkhtmlPdfGenerator {
    private URL coverHtml;
    private URL footerHtml;
    private URL headerHtml;
    private URL tocXsl;
    private String wkHtmlToPdfCommand = "wkhtmltopdf";
    private PrintStream processOutputStream = System.out;
    private ContextProperties properties = new ContextProperties();
    private File workingDir;
    private Map<URL, File> tempFileCache = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(WkhtmlPdfGenerator.class);

    public File generatePdfFromHtml(File file) {
        Preconditions.checkArgument((this.workingDir != null ? 1 : 0) != 0, (Object)"Working directory must be provided.");
        String string = IOUtils.extractFileNameWithoutExtension(file);
        File file2 = IOUtils.createFileNameWithNewExtension(file, this.workingDir, "pdf");
        logger.info("Creating pdf '{}' from from html source '{}'.", (Object)file2, (Object)file);
        ContextProperties contextProperties = this.preparePlaceholderValues(string);
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(this.wkHtmlToPdfCommand);
        ArrayList arrayList2 = Lists.newArrayList();
        arrayList.add("--disable-javascript");
        arrayList.add("--image-dpi");
        arrayList.add("1024");
        arrayList.add("--margin-bottom");
        arrayList.add("12");
        arrayList.add("--print-media-type");
        arrayList2.add(this.processOption(arrayList, "html", contextProperties, this.headerHtml, "--header-html"));
        arrayList2.add(this.processOption(arrayList, "html", contextProperties, this.footerHtml, "--footer-html"));
        arrayList2.add(this.processOption(arrayList, "html", contextProperties, this.coverHtml, "cover"));
        arrayList2.add(this.processOption(arrayList, "xsl", contextProperties, this.tocXsl, "toc", "--xsl-style-sheet"));
        arrayList.add(file.getAbsolutePath());
        arrayList.add(file2.getAbsolutePath());
        this.executeWkhtmlCommand(arrayList);
        WkhtmlPdfGenerator.deleteTempFiles(arrayList2);
        return file2;
    }

    private ContextProperties preparePlaceholderValues(String string) {
        ContextProperties contextProperties = new ContextProperties();
        contextProperties.putAll((Map)((Object)this.properties));
        String string2 = contextProperties.get(string + ".title", string);
        contextProperties.put("title", string2);
        return contextProperties;
    }

    private File processOption(List<String> list, String string, ContextProperties contextProperties, URL uRL, String ... stringArray) {
        if (uRL != null) {
            File file = this.createFileForUrlWithPlaceholdersReplaced(uRL, contextProperties, string);
            list.addAll(Arrays.asList(stringArray));
            list.add(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileForUrlWithPlaceholdersReplaced(URL uRL, ContextProperties contextProperties, String string) {
        try {
            File file = this.downloadUrl(uRL, string);
            File file2 = this.createTempFile(string);
            FileWriter fileWriter = new FileWriter(file2);
            FileReader fileReader = new FileReader(file);
            try {
                IOUtils.replacePlaceholders(fileReader, contextProperties, fileWriter);
            }
            finally {
                Closeables.closeQuietly((Closeable)fileWriter);
                Closeables.closeQuietly((Closeable)fileReader);
            }
            return file2;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    private File downloadUrl(URL uRL, String string) throws IOException {
        if (this.tempFileCache.containsKey(uRL)) {
            return this.tempFileCache.get(uRL);
        }
        File file = this.createTempFile(string);
        IOUtils.copy(uRL, file);
        this.tempFileCache.put(uRL, file);
        return file;
    }

    private static void deleteTempFiles(Collection<File> collection) {
        for (File file : collection) {
            if (file == null) continue;
            file.delete();
        }
    }

    public void clearTemporaryFiles() {
        WkhtmlPdfGenerator.deleteTempFiles(this.tempFileCache.values());
    }

    private File createTempFile(String string) throws IOException {
        return File.createTempFile("deployit", "." + string, this.workingDir);
    }

    private void executeWkhtmlCommand(List<String> list) {
        try {
            int n = this.executeCommand(list.toArray(new String[list.size()]));
            if (n != 0) {
                throw new RuntimeException("Failed to generate pdf. Return code '" + n + "' from executing : " + list);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    private int executeCommand(String[] stringArray) throws IOException {
        String string;
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(this.workingDir);
        logger.info("Executing command {}", (Object)Joiner.on((char)' ').join((Object[])stringArray));
        Process process = processBuilder.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            logger.debug(string);
            if (string.startsWith("[")) continue;
            this.processOutputStream.println(string);
        }
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            logger.error("Error while waiting for command", (Throwable)interruptedException);
            return 1;
        }
    }

    public void setCoverHtml(URL uRL) {
        this.coverHtml = uRL;
    }

    public void setFooterHtml(URL uRL) {
        this.footerHtml = uRL;
    }

    public void setHeaderHtml(URL uRL) {
        this.headerHtml = uRL;
    }

    public void setTocXsl(URL uRL) {
        this.tocXsl = uRL;
    }

    public void setWkHtmlToPdfCommand(String string) {
        this.wkHtmlToPdfCommand = string;
    }

    public void setProcessOutputStream(PrintStream printStream) {
        this.processOutputStream = printStream;
    }

    public void setWorkingDir(File file) {
        this.workingDir = file;
    }

    public void setProperties(ContextProperties contextProperties) {
        this.properties = contextProperties;
    }
}

