/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    private static InputSupplier<InputStream> newUrlInputSupplier(final URL uRL) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return uRL.openStream();
            }
        };
    }

    public static void copy(URL uRL, File file) {
        try {
            Files.copy(IOUtils.newUrlInputSupplier(uRL), (File)file);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    public static String getText(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream));
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    public static String getText(File file) {
        try {
            return new String(Files.toByteArray((File)file));
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    public static void copyDirectory(File file, File file2) {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (String string : file.list()) {
                IOUtils.copyDirectory(new File(file, string), new File(file2, string));
            }
        } else {
            try {
                Files.copy((File)file, (File)file2);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException((Throwable)iOException);
            }
        }
    }

    public static String replacePlaceholders(String string, ContextProperties contextProperties) {
        StringWriter stringWriter = new StringWriter();
        IOUtils.replacePlaceholders(new StringReader(string), contextProperties, stringWriter);
        return stringWriter.toString();
    }

    public static void replacePlaceholders(Reader reader, ContextProperties contextProperties, Writer writer) {
        try {
            if (contextProperties == null || contextProperties.isEmpty()) {
                IOUtils.copy(reader, writer);
            }
            Mustache.compiler().compile(reader).execute((Object)new MustacheContext((Map)((Object)contextProperties)), writer);
        }
        catch (MustacheException mustacheException) {
            throw new RuntimeException("Could not replace keys in " + reader, mustacheException);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    private static int copy(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            n += n2;
        }
        return n;
    }

    public static File createUniqueFileNameWithNewExtension(File file, File file2, String string) {
        String string2 = IOUtils.extractFileNameWithoutExtension(file);
        String string3 = string2 + "." + string;
        for (int i = 1; i < 50; ++i) {
            File file3 = new File(file2, string3);
            if (!file3.exists()) {
                return file3;
            }
            string3 = string2 + i + "." + string;
        }
        throw new RuntimeException("Cannot generate unique file name for '" + string2 + "." + string + "' in directory " + file2.getAbsolutePath());
    }

    public static File createFileNameWithNewExtension(File file, File file2, String string) {
        String string2 = IOUtils.extractFileNameWithoutExtension(file);
        String string3 = string2 + "." + string;
        File file3 = new File(file2, string3);
        if (file3.exists()) {
            file3.delete();
            try {
                file3.createNewFile();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException();
            }
        }
        return file3;
    }

    public static String extractFileNameWithoutExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String extractFileName(URL uRL) {
        String string = uRL.toString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        int n = string.lastIndexOf(47);
        return string.substring(n + 1);
    }

    public static String extractFileNameExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static File explodeArchive(File var0, File var1_1) {
        try {
            var2_2 = new ZipInputStream(new FileInputStream(var0));
            if (!var1_1.exists()) {
                var1_1.mkdir();
            }
            while (true) lbl-1000:
            // 5 sources

            {
                if ((var3_4 = var2_2.getNextEntry()) == null) {
                    return var1_1;
                }
                try {
                    if (var3_4.isDirectory()) {
                        var4_6 = new File(var1_1, var3_4.getName());
                        if (var4_6.exists()) ** GOTO lbl-1000
                        IOUtils.isTrue(var4_6.mkdirs(), "Could not create directory: " + var3_4.getName());
                    }
                    var4_6 = new File(var1_1, var3_4.getName());
                    var5_7 = var4_6.getParent();
                    if (var5_7 != null && !(var6_8 = new File(var5_7)).exists()) {
                        IOUtils.isTrue(var6_8.mkdirs(), "Could not create directory: " + var3_4.getName());
                    }
                    if (!var4_6.exists()) {
                        IOUtils.isTrue(var4_6.createNewFile(), "Could not create file: " + var3_4.getName());
                    }
                    ByteStreams.copy((InputStream)var2_2, (OutputStream)new FileOutputStream(var4_6));
                }
                finally {
                    var2_2.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException var2_3) {
            try {
                Files.deleteRecursively((File)var1_1);
            }
            catch (Exception var3_5) {
                IOUtils.logger.error("Could not delete {}", (Object)var1_1, (Object)var3_5);
            }
            throw new RuntimeIOException((Throwable)var2_3);
        }
        ** GOTO lbl-1000
    }

    private static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    private static class MustacheContext
    extends ForwardingMap<String, Object> {
        private Map<String, Object> delegate = Maps.newHashMap();

        private MustacheContext(Map<String, Object> map) {
            this.delegate = map;
        }

        protected Map<String, Object> delegate() {
            return this.delegate;
        }

        public Object get(Object object) {
            if (this.delegate.containsKey(object)) {
                return this.delegate.get(object);
            }
            String string = object + ".";
            HashMap hashMap = Maps.newHashMap();
            for (String string2 : this.delegate.keySet()) {
                if (string2.startsWith(string)) {
                    hashMap.put(string2.substring(string.length()), this.delegate.get(string2));
                }
                if (hashMap.isEmpty()) continue;
                return new MustacheContext(hashMap);
            }
            return null;
        }
    }
}

