/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.documentation.CiReferenceHtmlGenerator;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.deployit.documentation.WkhtmlPdfGenerator;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.pegdown.PegDownProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGenerator {
    @Option(name="-pdfCover", usage="Url to the html page that is to be used as the cover page in the generated pdf.")
    private URL pdfCoverHtml;
    @Option(name="-pdfFooter", usage="Url to the html page that is to be used as the footer on each page in the generated pdf.")
    private URL pdfFooterHtml;
    @Option(name="-pdfHeader", usage="Url to the html page that is to be used as the footer on each page in the generated pdf.")
    private URL pdfHeaderHtml;
    @Option(name="-pdfTocXsl", usage="Url to the xsl that is to be used to generate the html page for the table of content in the generated pdf.")
    private URL pdfTocXsl;
    @Option(name="-htmlFooter", usage="Url to the html snippet that is appended to the generated html document.")
    private URL htmlFooterSnippet;
    @Option(name="-htmlHeader", usage="Url to the html snippet that is added to the head tag in the generated html document.")
    private URL htmlHeaderSnippet;
    @Option(name="-resource", usage="Url to the web resource file(s)/zip(s) or local file(s)/folder(s) containing resources like images, css, etc.")
    private List<URL> resources = Lists.newArrayList();
    @Option(name="-single", usage="Generate a single document from the multiple sources")
    private boolean generateSingleDocument;
    @Option(name="-generatePdf", usage="Indicates if pdf documentation must be generated. Default is false.")
    private boolean generatePdf;
    @Option(name="-source", usage="Markdown file(s) used as the source for document generation.", required=true)
    private List<File> markdownSources = Lists.newArrayList();
    @Option(name="-workingDir", usage="Working directory to which documents are generated to.", required=true)
    private File workingDir;
    @Option(name="-properties", usage="Properties used to customize the generation for individual documents.\nProperty name is a compound key, starting with the document file name without extension. eg. filePluginManual\n'appendCiReference' : Specify if the document requires ci reference documentation append. eg. filePluginManual.appendCiReference=true.\n'prefixes' : Comma separated string for which plugin namespaces get generated ci documentation.eg. filePluginManual.prefixes=file,udm.\n             Omitted prefixes results in ci reference documentation for all types.\n 'title' : Tile of the documents as it appears on the pdf cover eg. filePluginManual.title=File Manual\n 'version' : Version of the plugin.\n\n You can supply any other property you may need to replace during generation. You can use {{prop}} as the placeholder in your markdowon.")
    private File propertiesSource;
    @Option(name="-wkhtmltopdf", usage="Command to execute wkhtmltopdf. Default is 'wkhtmltopdf'")
    private String wkHtmlToPdfCommand = "wkhtmltopdf";
    @Option(name="-htmlTemplate", usage="Url to the html template that is to be used to generate the html document.", required=true)
    private URL htmlTemplate;
    private PegDownProcessor markdownProcessor = new PegDownProcessor();
    private ContextProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(DocumentGenerator.class);

    public static void main(String[] args) {
        DocumentGenerator documentGenerator = new DocumentGenerator();
        CmdLineParser parser = new CmdLineParser((Object)documentGenerator);
        try {
            parser.parseArgument(args);
            documentGenerator.generate();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java DocumentGenerator [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            System.exit(1);
        }
    }

    private void generate() {
        this.downloadResourcesToWorkingDir();
        List<File> htmlFiles = this.generateHtmlFromMarkdownSources();
        if (this.generatePdf) {
            this.generatePdfFromHtml(htmlFiles);
        }
    }

    private void downloadResourcesToWorkingDir() {
        for (URL resource : this.resources) {
            String filename = IOUtils.extractFileName(resource);
            String ext = IOUtils.extractFileNameExtension(filename);
            logger.info("Processing resource '{}'. Resource has a file name of '{}' with extension '{}'.", new Object[]{resource, filename, ext});
            if ("zip".equals(ext)) {
                this.copyUncompressed(resource, filename);
                continue;
            }
            if ("".equals(ext)) {
                this.copyLocalFolder(resource, filename);
                continue;
            }
            IOUtils.copy(resource, new File(this.workingDir, filename));
        }
    }

    private void copyUncompressed(URL resource, String filename) {
        File archive = new File(this.workingDir, filename);
        IOUtils.copy(resource, archive);
        IOUtils.explodeArchive(archive, this.workingDir);
        archive.delete();
    }

    private void copyLocalFolder(URL resource, String folder) {
        File sourceFolder = null;
        try {
            sourceFolder = new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        IOUtils.copyDirectory(sourceFolder, new File(this.workingDir, folder));
    }

    private List<File> generateHtmlFromMarkdownSources() {
        List<Object> htmlFiles = Lists.newArrayList();
        if (this.generateSingleDocument) {
            htmlFiles.add(this.generateSinglePageHtml());
        } else {
            htmlFiles = this.generateMultiplePageHtml();
        }
        return htmlFiles;
    }

    private List<File> generatePdfFromHtml(List<File> htmlFiles) {
        logger.info("Creating pdf from html sources '{}'.", htmlFiles);
        WkhtmlPdfGenerator generator = new WkhtmlPdfGenerator();
        generator.setCoverHtml(this.pdfCoverHtml);
        generator.setFooterHtml(this.pdfFooterHtml);
        generator.setHeaderHtml(this.pdfHeaderHtml);
        generator.setProperties(this.getProperties());
        generator.setTocXsl(this.pdfTocXsl);
        generator.setWkHtmlToPdfCommand(this.wkHtmlToPdfCommand);
        generator.setWorkingDir(this.workingDir);
        ArrayList pdfFiles = Lists.newArrayList();
        for (File htmlFile : htmlFiles) {
            pdfFiles.add(generator.generatePdfFromHtml(htmlFile));
        }
        generator.clearTemporaryFiles();
        return pdfFiles;
    }

    private File generateSinglePageHtml() {
        File singleDocument = new File(this.workingDir, "singleDocument.html");
        String config = "singleDocument";
        logger.info("Creating single html document '{}' from markdown sources '{}'.", (Object)singleDocument.getAbsolutePath(), this.markdownSources);
        PrintWriter out = null;
        try {
            String header = this.getHeader(config);
            String body = this.getBody(config);
            String footer = this.getFooter(config);
            String template = this.getTemplate();
            out = new PrintWriter(new FileWriter(singleDocument));
            this.writeDocument(out, config, template, header, body, footer);
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)out);
        return singleDocument;
    }

    private String getTemplate() {
        String result = "";
        if (this.htmlTemplate != null) {
            result = IOUtils.getText(this.htmlTemplate);
        }
        return result;
    }

    private String getBody(String config) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        for (File markdownSource : this.markdownSources) {
            this.generateHtmlBodyFromMarkdownSource(markdownSource, out, config);
        }
        this.finalizeBody(out, config);
        return sw.toString();
    }

    private String getBody(String config, File markdownSource) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.generateHtmlBodyFromMarkdownSource(markdownSource, out, config);
        this.finalizeBody(out, config);
        return sw.toString();
    }

    private String getFooter(String config) {
        return this.getSnippetWithPlaceholderReplacementOrBlank(this.htmlFooterSnippet, config);
    }

    private String getHeader(String config) {
        return this.getSnippetWithPlaceholderReplacementOrBlank(this.htmlHeaderSnippet, config);
    }

    private String getSnippetWithPlaceholderReplacementOrBlank(URL snippet, String config) {
        if (snippet == null) {
            return "";
        }
        ContextProperties ctx = this.getRootContextMergedWithConfig(config);
        return IOUtils.replacePlaceholders(IOUtils.getText(snippet), ctx);
    }

    private void writeDocument(PrintWriter out, String config, String template, String header, String body, String footer) {
        ContextProperties ctx = this.getRootContextMergedWithConfig(config);
        ctx.put("header", header);
        ctx.put("body", body);
        ctx.put("footer", footer);
        out.println(IOUtils.replacePlaceholders(template, ctx));
    }

    private List<File> generateMultiplePageHtml() {
        logger.info("Creating multiple html documents from markdown sources '{}'.", this.markdownSources);
        ArrayList generatedFiles = Lists.newArrayList();
        for (File markdownSource : this.markdownSources) {
            String config = IOUtils.extractFileNameWithoutExtension(markdownSource);
            File htmlFile = IOUtils.createFileNameWithNewExtension(markdownSource, this.workingDir, "html");
            logger.info("Creating html document '{}' from markdown source '{}'.", (Object)htmlFile.getAbsolutePath(), (Object)markdownSource.getAbsolutePath());
            PrintWriter out = null;
            try {
                String header = this.getHeader(config);
                String body = this.getBody(config, markdownSource);
                String footer = this.getFooter(config);
                String template = this.getTemplate();
                out = new PrintWriter(new FileWriter(htmlFile));
                this.writeDocument(out, config, template, header, body, footer);
                generatedFiles.add(htmlFile);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeIOException((Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(out);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)out);
        }
        return generatedFiles;
    }

    protected PrintWriter initializeHead(PrintWriter out) {
        return out;
    }

    protected void finalizeBody(PrintWriter out, String config) {
        ContextProperties ctx = this.getRootContextMergedWithConfig(config);
        if ("true".equals(ctx.get("appendCiReference"))) {
            ArrayList prefixes = Collections.emptyList();
            if (ctx.get("prefixes") != null) {
                Iterable split = Splitter.on((char)',').trimResults().split((CharSequence)ctx.get("prefixes"));
                prefixes = Lists.newArrayList((Iterable)split);
            }
            CiReferenceHtmlGenerator generator = new CiReferenceHtmlGenerator(prefixes, out);
            generator.generate();
        }
    }

    private void generateHtmlBodyFromMarkdownSource(File markdownSource, PrintWriter out, String config) {
        String markdownText = IOUtils.getText(markdownSource);
        ContextProperties ctx = this.getRootContextMergedWithConfig(config);
        markdownText = IOUtils.replacePlaceholders(markdownText, ctx);
        String html = this.markdownProcessor.markdownToHtml(markdownText);
        logger.trace("Generate html from markdown file '{}' :\n {}", (Object)markdownSource.getAbsolutePath(), (Object)html);
        out.write(html);
    }

    private ContextProperties getRootContextMergedWithConfig(String config) {
        ContextProperties ctx = this.getProperties().getRootContext();
        ctx.putAll((Map)((Object)this.getProperties().getContext(config)));
        return ctx;
    }

    private ContextProperties getProperties() {
        if (this.properties == null) {
            this.properties = new ContextProperties();
            if (this.propertiesSource != null) {
                try {
                    Properties temp = new Properties();
                    temp.load(new FileInputStream(this.propertiesSource));
                    for (String key : temp.stringPropertyNames()) {
                        this.properties.put(key, temp.getProperty(key));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        }
        return this.properties;
    }
}

