/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Information about task exposed via its root block.
 */
@PublicApiRef
public interface TaskWithBlock extends SerializableTask {

    /**
     * Returns state of the root block
     */
    BlockState getBlock();

    /**
     * Returns list of block ids which are active at the moment.
     */
    List<String> getActiveBlocks();

}
