/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.security;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.deployit.engine.api.security.Role;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RolePrincipals
extends AbstractDto {
    private Role role;
    private List<String> principals = new ArrayList<String>();

    public RolePrincipals() {
    }

    public RolePrincipals(Role role, List<String> principals) {
        this.role = role;
        this.principals = new ArrayList<String>(principals);
    }

    @XmlElement
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @XmlElement
    public List<String> getPrincipals() {
        this.deduplicate();
        return this.principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
        this.deduplicate();
    }

    public void addPrincipals(List<String> principals) {
        this.principals.addAll(principals);
        this.deduplicate();
    }

    private void deduplicate() {
        LinkedHashSet<String> principalSet = new LinkedHashSet<String>(this.principals);
        this.principals.clear();
        this.principals.addAll(principalSet);
    }
}

