/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import org.joda.time.DateTime

case class ApplicationDeploymentPackage(operation: String,
                                        applicationName: String,
                                        applicationUid: String,
                                        versionTag: VersionTag)

case class DeployedApplicationPackage(operation: String,
                                      applicationName: String,
                                      applicationUid: String,
                                      applicationPath: String,
                                      versionTag: VersionTag,
                                      destination: String,
                                      destinationUid: String,
                                      namespace: String)

case class ApplicationDeploymentPackageState(applicationName: String,
                                             applicationUid: String,
                                             applicationPath: String,
                                             state: DeploymentPackageState)

case class VersionTag(label: String, state: String)

case class DeploymentPackageState(destination: String,
                                  destinationUid: String,
                                  namespace: String,
                                  versionTag: VersionTag,
                                  deploymentStatus: String,
                                  deploymentType: String,
                                  user: String,
                                  lastChangeTime: DateTime)

object StateOperation {
  final val CreateState = "create"
  final val RemoveState = "remove"
}
