/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Contains information about a satellite instance.
 */
@PublicApiRef
@XmlRootElement(name = "queued-task")
public class QueuedTask extends AbstractDto {

    private String id;
    private String taskType;
    private String queuedDate;
    private int queuedOrder;
    private List<String> associatedSatelliteIds = new ArrayList<>();
    private String environmentId;

    public QueuedTask() {
    }

    public QueuedTask(String id, String taskType, String queuedDate, int queuedOrder, List<String> associatedSatelliteIds, String environmentId) {
        this.id = id;
        this.taskType = taskType;
        this.queuedDate = queuedDate;
        this.queuedOrder = queuedOrder;
        this.associatedSatelliteIds = associatedSatelliteIds;
        this.environmentId = environmentId;
    }

    @XmlElement(name = "id")
    public String getId() {
        return id;
    }

    @XmlElement(name = "task-type")
    public String getTaskType() {
        return taskType;
    }

    @XmlElement(name = "queued-date")
    public String getQueuedDate() {
        return queuedDate;
    }

    @XmlElement(name = "queued-order")
    public int getQueuedOrder() {
        return queuedOrder;
    }

    @XmlElementWrapper(name = "associated-satellite-ids")
    @XmlElement(name = "associated-satellite-id")
    public List<String> getAssociatedSatelliteIds() {
        return associatedSatelliteIds;
    }

    @XmlElement(name = "environment-id")
    public String getEnvironmentId() {
        return environmentId;
    }
}
