/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.security;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;

/**
 * XL Deploy supports a role-based access control scheme to ensure the security of your middleware and deployments.
 * The security mechanism is based on the concepts of roles and permissions. A (security) role is a group of entities
 * that can be authenticated and that can be assigned permissions over resources in XL Deploy. These rights can be either
 * global (that is, they apply to all of XL Deploy, such as login permission) or relevant for a particular CI or set
 * of CIs (for instance, the permission to read certain CIs in the repository).
 *
 * The security system uses the same permissions whether the system is accessed via the GUI or the CLI.
 */
@XmlRootElement
@PublicApiRef
public class Permission extends AbstractDto {
    private String permissionName;
    private String level;
    private String root;

    public Permission() {
    }

    public Permission(String permissionName, String level, String root) {
        this.permissionName = permissionName;
        this.level = level;
        this.root = root;
    }

    /**
     * @return The name of the permission.
     */
    @XmlAttribute
    public String getPermissionName() {
        return permissionName;
    }

    /**
     * @param permissionName The name of the permission.
     */
    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    /**
     * @return Whether this permission is global permissions, or applicable on a CI level. Possible values: GLOBAL or CI.
     */
    @XmlAttribute
    public String getLevel() {
        return level;
    }

    /**
     * @param level Whether this permission is global permissions, or applicable on a CI level. Possible values: GLOBAL or CI.
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * @return If set, the root node in the repository this permission is relevant for. Possible values: {@code Applications}, {@code Environments} or {@code Infrastructure}.
     */
    @XmlAttribute
    public String getRoot() {
        return root;
    }

    /**
     * @param root If set, the root node in the repository this permission is relevant for. Possible values: {@code Applications}, {@code Environments} or {@code Infrastructure}.
     */
    public void setRoot(String root) {
        this.root = root;
    }
}
