/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

/**
 * Contains information about a satellite instance.
 */
@XmlRootElement(name = "satellite-info")
@PublicApiRef
public class SatelliteInfo extends AbstractDto {

    private boolean available;

    private String satelliteId;

    private String version;

    private Boolean pluginsSynced;

    /**
     * @return The status whether the satellite available.
     */
    @XmlElement(name = "available")
    public Boolean isAvailable() {
        return available;
    }

    /**
     * @return The status whether the satellite available.
     */
    @XmlElement(name = "satellite-id")
    public String getSatelliteId() {
        return satelliteId;
    }

    /**
     * @return The satellite version.
     */
    @XmlElement(name = "version")
    public String getVersion() {
        return version;
    }

    /**
     * @return The satellite version.
     */
    @XmlElement(name = "plugins-synced")
    public Boolean arePluginsSynced() {
        return pluginsSynced;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public void setSatelliteId(String satelliteId) {
        this.satelliteId = satelliteId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPluginsSynced(Boolean pluginsSynced) {
        this.pluginsSynced = pluginsSynced;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SatelliteInfo that = (SatelliteInfo) o;
        return available == that.available &&
                Objects.equals(satelliteId, that.satelliteId) &&
                Objects.equals(version, that.version) &&
                Objects.equals(pluginsSynced, that.pluginsSynced);
    }

    @Override
    public int hashCode() {
        return Objects.hash(available, satelliteId, version, pluginsSynced);
    }
}
