/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Contains information about a server plugin, as specified in <code>plugin-version.properties</code> file.
 */
@XmlRootElement(name = "plugin-info")
@PublicApiRef
public class ServerPluginInfo extends AbstractDto {

    private String plugin;

    private String version;

    public ServerPluginInfo() {
    }

    public ServerPluginInfo(String plugin, String version) {
        this.plugin = plugin;
        this.version = version;
    }

    /**
     * @return The name of the plugin.
     */
    @XmlAttribute
    public String getPlugin() {
        return plugin;
    }

    /**
     * @param plugin The name of the plugin.
     */
    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    /**
     * @return  The version of the plugin.
     */
    @XmlAttribute
    public String getVersion() {
        return version;
    }

    /**
     * @param version The version of the plugin.
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
