/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Contains information about server state.
 */
@XmlRootElement(name = "server-state")
@PublicApiRef
public class ServerState extends AbstractDto {

    private String currentMode;

    public ServerState() {}

    /**
     * @return current server mode
     */
    @XmlElement(name = "current-mode")
    public String getCurrentMode() {
        return currentMode;
    }

    /**
     * @param currentMode Current server mode
     */
    public void setCurrentMode(final String currentMode) { this.currentMode = currentMode; }
}
