/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.EditRolePermissionsDto;
import com.xebialabs.deployit.engine.api.dto.InheritParentPermissionDto;
import com.xebialabs.xlplatform.documentation.PublicApi;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Path(value="/security")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public interface PermissionService {
    @GET
    @Path(value="granted-permissions/{role}")
    public Map<String, Collection<String>> getGrantedPermissions(@PathParam(value="role") String var1);

    @GET
    @Path(value="granted-permissions/id/{roleId}")
    public Map<String, Collection<String>> getGrantedPermissionsById(@PathParam(value="roleId") String var1);

    @GET
    @Path(value="granted-permissions")
    public Map<String, Collection<String>> getMyGrantedPermissions();

    @GET
    @Path(value="permission/{permission}/{role}/{id:.+}")
    public boolean isGranted(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @GET
    @Path(value="permission/{permission}/{role}")
    default public boolean isGranted(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        return this.isGranted(permission, "", role);
    }

    @PUT
    @Path(value="permission/{permission}/{role}/{id:.*}")
    public void grant(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @PUT
    @Path(value="permission/{permission}/{role}")
    default public void grant(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        this.grant(permission, "", role);
    }

    @DELETE
    @Path(value="permission/{permission}/{role}/{id:.+}")
    public void revoke(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @DELETE
    @Path(value="permission/{permission}/{role}")
    default public void revoke(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        this.revoke(permission, "", role);
    }

    @GET
    @Path(value="check/{permission}/{id:.+}")
    public boolean isGrantedToMe(@PathParam(value="permission") String var1, @PathParam(value="id") String var2);

    @GET
    @Path(value="check/{permission}")
    default public boolean isGrantedToMe(@PathParam(value="permission") String permission) {
        return this.isGrantedToMe(permission, "");
    }

    @PUT
    @Path(value="roles/{id:.+}/permissions")
    public void updatePermissions(@PathParam(value="id") String var1, List<EditRolePermissionsDto> var2);

    @PUT
    @Path(value="permission/inherit-parent/{id:.+}")
    public void inheritParentPermissions(@PathParam(value="id") String var1, InheritParentPermissionDto var2);
}

