package com.xebialabs.deployit.engine.api;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.ServerInfo;

/**
 * Services related to the operation of the Deployit server process.
 */
@Path("/server")
@Produces(MediaType.TEXT_XML)
public interface ServerService {

    /**
     * Returns information about the configuration of the sever. For example: version, plugins, and classpath.
     *
     * @return an information object.
     */
    @GET
    @Path("info")
    ServerInfo getInfo();

    /**
     * Runs the garbage collector on the repository.
     *
     * @permission admin
     */
    @POST
    @Path("gc")
    void gc();

    /**
     * Logs out the current user.
     */
    @POST
    @Path("logout")
    void logout();

    /**
     * Stops the server process in a graceful manner.
     *
     * @permission admin
     */
    @POST
    @Path("shutdown")
    void shutdown();
}
