/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import java.util.concurrent.atomic.AtomicReference;

import com.xebialabs.deployit.engine.api.task.TaskCreationService;

public class ServiceHolder {

    private static final AtomicReference<ControlService> controlService = new AtomicReference<>();
    private static final AtomicReference<DeploymentService> deploymentService = new AtomicReference<>();
    private static final AtomicReference<InspectionService> inspectionService = new AtomicReference<>();
    private static final AtomicReference<MetadataService> metadataService = new AtomicReference<>();
    private static final AtomicReference<PackageService> packageService = new AtomicReference<>();
    private static final AtomicReference<PermissionService> permissionService = new AtomicReference<>();
    private static final AtomicReference<RoleService> roleService = new AtomicReference<>();
    private static final AtomicReference<ServerService> serverService = new AtomicReference<>();
    @SuppressWarnings("deprecation") private static final AtomicReference<TaskService> taskService = new AtomicReference<>();
    private static final AtomicReference<TaskBlockService> taskBlockService = new AtomicReference<>();
    private static final AtomicReference<UserService> userService = new AtomicReference<>();
    private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference<>();
    private static final AtomicReference<TaskCreationService> taskCreationService = new AtomicReference<>();

    @SuppressWarnings("unused")
    public ServiceHolder(
            ControlService controlService,
            DeploymentService deploymentService,
            InspectionService inspectionService,
            MetadataService metadataService,
            PackageService packageService,
            PermissionService permissionService,
            RepositoryService repositoryService,
            RoleService roleService,
            ServerService serverService,
            @SuppressWarnings("deprecation") TaskService taskService,
            TaskBlockService taskBlockService,
            UserService userService,
            TaskCreationService taskCreationService) {
        ServiceHolder.controlService.set(controlService);
        ServiceHolder.deploymentService.set(deploymentService);
        ServiceHolder.inspectionService.set(inspectionService);
        ServiceHolder.metadataService.set(metadataService);
        ServiceHolder.packageService.set(packageService);
        ServiceHolder.permissionService.set(permissionService);
        ServiceHolder.repositoryService.set(repositoryService);
        ServiceHolder.roleService.set(roleService);
        ServiceHolder.serverService.set(serverService);
        ServiceHolder.taskService.set(taskService);
        ServiceHolder.taskBlockService.set(taskBlockService);
        ServiceHolder.userService.set(userService);
        ServiceHolder.taskCreationService.set(taskCreationService);
    }

    @SuppressWarnings("unused")
    public ServiceHolder() {
    }

    public static ControlService getControlService() {
        return controlService.get();
    }

    public static DeploymentService getDeploymentService() {
        return deploymentService.get();
    }

    public static InspectionService getInspectionService() {
        return inspectionService.get();
    }

    public static MetadataService getMetadataService() {
        return metadataService.get();
    }

    public static PackageService getPackageService() {
        return packageService.get();
    }

    public static PermissionService getPermissionService() {
        return permissionService.get();
    }

    public static RepositoryService getRepositoryService() {
        return repositoryService.get();
    }

    public static RoleService getRoleService() {
        return roleService.get();
    }

    public static ServerService getServerService() {
        return serverService.get();
    }

    @SuppressWarnings("deprecation") public static TaskService getTaskService() {
        return taskService.get();
    }

    public static TaskBlockService getTaskBlockService() {
        return taskBlockService.get();
    }

    public static UserService getUserService() {
        return userService.get();
    }

    public static TaskCreationService getTaskCreationService() {
        return taskCreationService.get();
    }
}
