/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.upgrade;

import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;

public abstract class Upgrade
implements Comparable<Upgrade> {
    protected boolean askForUpgrade = true;

    public abstract boolean doUpgrade() throws UpgradeException;

    public abstract Version upgradeVersion();

    @Override
    public int compareTo(Upgrade o) {
        if (this.upgradeVersion().compareTo(o.upgradeVersion()) == 0) {
            return this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        }
        return this.upgradeVersion().compareTo(o.upgradeVersion());
    }

    public boolean shouldBeApplied(Version currentVersion) {
        return currentVersion.getComponent().equals(this.upgradeVersion().getComponent()) && currentVersion.compareTo(this.upgradeVersion()) < 0;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean isAskForUpgrade() {
        return this.askForUpgrade;
    }
}

