/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class CiRenamedEvent extends CiBaseEvent {

    private ConfigurationItem ci;
    private String newName;

    public CiRenamedEvent(ConfigurationItem ci, String newName) {
        super("repository", String.format("Renamed CI %s to %s", format(ci), format(newName)));
        this.ci = ci;
        this.newName = newName;
    }

    public ConfigurationItem getCi() {
        return ci;
    }

    public String getId() {
        return ci.getId();
    }

    public String getNewName() {
        return newName;
    }

}
