/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.xltype.serialization.CiWriter;

@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
public class ConfigurationItemIdListWriter implements MessageBodyWriter<Collection<ConfigurationItemId>> {

    private final TypeMatcher matcher = new TypeMatcher(Collection.class, ConfigurationItemId.class);
    protected FormatFactory formats = new FormatFactory();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return matcher.matches(type, genericType);
    }

    @Override
    public long getSize(Collection<ConfigurationItemId> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<ConfigurationItemId> cis, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
        OutputStream entityStream) throws IOException, WebApplicationException {

        CiWriter writer = formats.createCiWriter(mediaType);
        writer.typedCiReferences(cis);

        entityStream.write(writer.toString().getBytes());
    }


}
