/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.StepStateJsonConverter;

public class Converters {
    public static void checkArgument(boolean expression, String message, Object ... params) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, params));
        }
    }

    public static JsonWriter writePhaseContainer(PhaseContainerState phaseContainerState, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("root").value("true");
        Iterable blocks = phaseContainerState.getBlocks();
        if (blocks.iterator().hasNext()) {
            writer.key("blocks").array();
            for (PhaseState phase : blocks) {
                writer.object();
                Converters.writePhase(phase, writer, writeStepBlocks);
                writer.endObject();
            }
            writer.endArray();
        }
        return writer;
    }

    public static JsonWriter writePhase(PhaseState phase, JsonWriter writer, boolean writeStepBlocks) {
        Converters.writeBlockBasics((BlockState)phase, writer);
        writer.key("phase").value("true");
        writer.key("block");
        Converters.writeBlockTree(phase.getBlock(), writer, writeStepBlocks);
        return writer;
    }

    public static JsonWriter writeBlockBasics(BlockState block, JsonWriter writer) {
        writer.key("id").value(block.getId() == null ? "" : block.getId());
        writer.key("state").value(block.getState() == null ? null : block.getState().toString());
        writer.key("description").value(block.getDescription());
        writer.key("hasSteps").value(block.hasSteps());
        if (block instanceof StepBlockState) {
            writer.key("satelliteId").value(((StepBlockState)block).getSatelliteId());
        }
        if (block.getSatelliteConnectionState() != null) {
            writer.key("satelliteConnectionState").value(block.getSatelliteConnectionState().toString());
        }
        return writer;
    }

    public static JsonWriter writeBlockTree(BlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.object();
        Converters.writeBlockBasics(block, writer);
        if (block instanceof CompositeBlockState) {
            Converters.writeCompositeBlockState((CompositeBlockState)block, writer, writeStepBlocks);
        } else if (block instanceof StepBlockState) {
            Converters.writeStepBlockState((StepBlockState)block, writer, writeStepBlocks);
        } else if (block instanceof PhaseContainerState) {
            Converters.writePhaseContainer((PhaseContainerState)block, writer, writeStepBlocks);
        }
        writer.endObject();
        return writer;
    }

    public static JsonWriter writeCompositeBlockState(CompositeBlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("parallel").value(block.isParallel());
        if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
            writer.key("blocks").array();
            for (BlockState blockChild : block.getBlocks()) {
                Converters.writeBlockTree(blockChild, writer, writeStepBlocks);
            }
            writer.endArray();
        }
        return writer;
    }

    public static JsonWriter writeStepBlockState(StepBlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("currentStep").value(block.getCurrentStep());
        if (writeStepBlocks && block.getSteps() != null && !block.getSteps().isEmpty()) {
            StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();
            writer.key("steps").array();
            for (StepState stepState : block.getSteps()) {
                stepStateJsonConverter.writeJsonObject(stepState, writer);
            }
            writer.endArray();
        }
        return writer;
    }
}

