/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.jdom;

import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.joda.time.DateTime;

public class JdomWriter {
    private final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();
    private Document document;
    private Deque<Element> elementStack = new ArrayDeque<Element>();

    public JdomWriter() {
        this.document = new Document();
    }

    public JdomWriter element(String name) {
        return this.element(name, null);
    }

    public JdomWriter element(String name, Namespace namespace) {
        Element e = new Element(name, namespace);
        if (this.elementStack.isEmpty()) {
            this.document.addContent((Content)e);
        } else {
            this.elementStack.peek().addContent((Content)e);
        }
        this.elementStack.push(e);
        return this;
    }

    public JdomWriter endElement() {
        this.elementStack.pop();
        return this;
    }

    public JdomWriter attribute(String name, String value) {
        this.elementStack.peek().setAttribute(name, value);
        return this;
    }

    public JdomWriter attributeAsDate(String name, DateTime date) {
        this.attribute(name, this.dateTimeAdapter.marshal(date));
        return this;
    }

    public JdomWriter value(String value) {
        this.elementStack.peek().setText(value);
        return this;
    }

    public JdomWriter valueAsDate(DateTime date) {
        this.value(this.dateTimeAdapter.marshal(date));
        return this;
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(this.document, (Writer)stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }
}

