package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;

@XStreamProvider(readable = TaskPreviewBlock.class, tagName = "previewblock")
public class TaskPreviewBlockConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskPreviewBlock task = (TaskPreviewBlock) source;
        writer.addAttribute("id", task.getId());
        if (task.getBlock() != null) {
            writer.startNode("block");
            Converters.writePhaseContainer((PhaseContainerState) task.getBlock(), writer, context, true);
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TaskPreviewBlock block = new TaskPreviewBlock();
        block.setId(reader.getAttribute("id"));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("block".equals(reader.getNodeName())) {
                BlockState blockState = (BlockState) context.convertAnother(block, BlockState.class);
                block.setBlock(blockState);
            }
            reader.moveUp();
        }
        return block;
    }

    @Override
    public boolean canConvert(@SuppressWarnings("rawtypes") Class type) {
        return TaskPreviewBlock.class.isAssignableFrom(type);
    }
}
